# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SearchEntryPoint(object):
    """
    Contains the HTML and CSS to render the required Search Suggestions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SearchEntryPoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rendered_content:
            The value to assign to the rendered_content property of this SearchEntryPoint.
        :type rendered_content: str

        """
        self.swagger_types = {
            'rendered_content': 'str'
        }
        self.attribute_map = {
            'rendered_content': 'renderedContent'
        }
        self._rendered_content = None

    @property
    def rendered_content(self):
        """
        Gets the rendered_content of this SearchEntryPoint.
        The rendered content


        :return: The rendered_content of this SearchEntryPoint.
        :rtype: str
        """
        return self._rendered_content

    @rendered_content.setter
    def rendered_content(self, rendered_content):
        """
        Sets the rendered_content of this SearchEntryPoint.
        The rendered content


        :param rendered_content: The rendered_content of this SearchEntryPoint.
        :type: str
        """
        self._rendered_content = rendered_content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
