# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StepMessage(object):
    """
    Contents of a step message.
    """

    #: A constant which can be used with the severity property of a StepMessage.
    #: This constant has a value of "INFO"
    SEVERITY_INFO = "INFO"

    #: A constant which can be used with the severity property of a StepMessage.
    #: This constant has a value of "ERROR"
    SEVERITY_ERROR = "ERROR"

    #: A constant which can be used with the severity property of a StepMessage.
    #: This constant has a value of "WARNING"
    SEVERITY_WARNING = "WARNING"

    def __init__(self, **kwargs):
        """
        Initializes a new StepMessage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param message:
            The value to assign to the message property of this StepMessage.
        :type message: str

        :param code:
            The value to assign to the code property of this StepMessage.
        :type code: str

        :param timestamp:
            The value to assign to the timestamp property of this StepMessage.
        :type timestamp: datetime

        :param severity:
            The value to assign to the severity property of this StepMessage.
            Allowed values for this property are: "INFO", "ERROR", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        """
        self.swagger_types = {
            'message': 'str',
            'code': 'str',
            'timestamp': 'datetime',
            'severity': 'str'
        }
        self.attribute_map = {
            'message': 'message',
            'code': 'code',
            'timestamp': 'timestamp',
            'severity': 'severity'
        }
        self._message = None
        self._code = None
        self._timestamp = None
        self._severity = None

    @property
    def message(self):
        """
        **[Required]** Gets the message of this StepMessage.
        The status message of the steps in a recipe during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/oggra/rest-endpoints.html


        :return: The message of this StepMessage.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this StepMessage.
        The status message of the steps in a recipe during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/oggra/rest-endpoints.html


        :param message: The message of this StepMessage.
        :type: str
        """
        self._message = message

    @property
    def code(self):
        """
        **[Required]** Gets the code of this StepMessage.
        The code returned when GoldenGate reports an error while running a step during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/error-messages/ogg-00001-ogg-40000.html#GUID-97FF7AA7-7A5C-4AA7-B29F-3CC8D26761F2


        :return: The code of this StepMessage.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this StepMessage.
        The code returned when GoldenGate reports an error while running a step during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/error-messages/ogg-00001-ogg-40000.html#GUID-97FF7AA7-7A5C-4AA7-B29F-3CC8D26761F2


        :param code: The code of this StepMessage.
        :type: str
        """
        self._code = code

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this StepMessage.
        Date and time of a message issued by steps in a recipe during pipeline initialization.
        The format is defined by `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The timestamp of this StepMessage.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this StepMessage.
        Date and time of a message issued by steps in a recipe during pipeline initialization.
        The format is defined by `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param timestamp: The timestamp of this StepMessage.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this StepMessage.
        The severity returned when calling GoldenGate API messages for a step in a recipe during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/oggra/rest-endpoints.html

        Allowed values for this property are: "INFO", "ERROR", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this StepMessage.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this StepMessage.
        The severity returned when calling GoldenGate API messages for a step in a recipe during pipeline initialization.
        https://docs.oracle.com/en/middleware/goldengate/core/23/oggra/rest-endpoints.html


        :param severity: The severity of this StepMessage.
        :type: str
        """
        allowed_values = ["INFO", "ERROR", "WARNING"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
