# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppCertificates(object):
    """
    Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppCertificates object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cert_alias:
            The value to assign to the cert_alias property of this AppCertificates.
        :type cert_alias: str

        :param sha1_thumbprint:
            The value to assign to the sha1_thumbprint property of this AppCertificates.
        :type sha1_thumbprint: str

        :param kid:
            The value to assign to the kid property of this AppCertificates.
        :type kid: str

        :param x5t:
            The value to assign to the x5t property of this AppCertificates.
        :type x5t: str

        :param x509_base64_certificate:
            The value to assign to the x509_base64_certificate property of this AppCertificates.
        :type x509_base64_certificate: object

        """
        self.swagger_types = {
            'cert_alias': 'str',
            'sha1_thumbprint': 'str',
            'kid': 'str',
            'x5t': 'str',
            'x509_base64_certificate': 'object'
        }
        self.attribute_map = {
            'cert_alias': 'certAlias',
            'sha1_thumbprint': 'sha1Thumbprint',
            'kid': 'kid',
            'x5t': 'x5t',
            'x509_base64_certificate': 'x509Base64Certificate'
        }
        self._cert_alias = None
        self._sha1_thumbprint = None
        self._kid = None
        self._x5t = None
        self._x509_base64_certificate = None

    @property
    def cert_alias(self):
        """
        **[Required]** Gets the cert_alias of this AppCertificates.
        Certificate alias

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: none


        :return: The cert_alias of this AppCertificates.
        :rtype: str
        """
        return self._cert_alias

    @cert_alias.setter
    def cert_alias(self, cert_alias):
        """
        Sets the cert_alias of this AppCertificates.
        Certificate alias

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: none


        :param cert_alias: The cert_alias of this AppCertificates.
        :type: str
        """
        self._cert_alias = cert_alias

    @property
    def sha1_thumbprint(self):
        """
        Gets the sha1_thumbprint of this AppCertificates.
        sha1Thumbprint

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The sha1_thumbprint of this AppCertificates.
        :rtype: str
        """
        return self._sha1_thumbprint

    @sha1_thumbprint.setter
    def sha1_thumbprint(self, sha1_thumbprint):
        """
        Sets the sha1_thumbprint of this AppCertificates.
        sha1Thumbprint

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param sha1_thumbprint: The sha1_thumbprint of this AppCertificates.
        :type: str
        """
        self._sha1_thumbprint = sha1_thumbprint

    @property
    def kid(self):
        """
        Gets the kid of this AppCertificates.
        Certificate kid

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The kid of this AppCertificates.
        :rtype: str
        """
        return self._kid

    @kid.setter
    def kid(self, kid):
        """
        Sets the kid of this AppCertificates.
        Certificate kid

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param kid: The kid of this AppCertificates.
        :type: str
        """
        self._kid = kid

    @property
    def x5t(self):
        """
        Gets the x5t of this AppCertificates.
        Certificate x5t

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The x5t of this AppCertificates.
        :rtype: str
        """
        return self._x5t

    @x5t.setter
    def x5t(self, x5t):
        """
        Sets the x5t of this AppCertificates.
        Certificate x5t

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param x5t: The x5t of this AppCertificates.
        :type: str
        """
        self._x5t = x5t

    @property
    def x509_base64_certificate(self):
        """
        Gets the x509_base64_certificate of this AppCertificates.
        Base-64-encoded certificate.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: binary
         - uniqueness: none


        :return: The x509_base64_certificate of this AppCertificates.
        :rtype: object
        """
        return self._x509_base64_certificate

    @x509_base64_certificate.setter
    def x509_base64_certificate(self, x509_base64_certificate):
        """
        Sets the x509_base64_certificate of this AppCertificates.
        Base-64-encoded certificate.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: binary
         - uniqueness: none


        :param x509_base64_certificate: The x509_base64_certificate of this AppCertificates.
        :type: object
        """
        self._x509_base64_certificate = x509_base64_certificate

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
