# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SocialIdentityProvider(object):
    """
    Social Identity Provider
    """

    #: A constant which can be used with the idcs_prevented_operations property of a SocialIdentityProvider.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a SocialIdentityProvider.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a SocialIdentityProvider.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the status property of a SocialIdentityProvider.
    #: This constant has a value of "created"
    STATUS_CREATED = "created"

    #: A constant which can be used with the status property of a SocialIdentityProvider.
    #: This constant has a value of "deleted"
    STATUS_DELETED = "deleted"

    def __init__(self, **kwargs):
        """
        Initializes a new SocialIdentityProvider object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SocialIdentityProvider.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this SocialIdentityProvider.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this SocialIdentityProvider.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this SocialIdentityProvider.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this SocialIdentityProvider.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this SocialIdentityProvider.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this SocialIdentityProvider.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this SocialIdentityProvider.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this SocialIdentityProvider.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this SocialIdentityProvider.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this SocialIdentityProvider.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this SocialIdentityProvider.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this SocialIdentityProvider.
        :type tenancy_ocid: str

        :param name:
            The value to assign to the name property of this SocialIdentityProvider.
        :type name: str

        :param description:
            The value to assign to the description property of this SocialIdentityProvider.
        :type description: str

        :param enabled:
            The value to assign to the enabled property of this SocialIdentityProvider.
        :type enabled: bool

        :param account_linking_enabled:
            The value to assign to the account_linking_enabled property of this SocialIdentityProvider.
        :type account_linking_enabled: bool

        :param social_jit_provisioning_enabled:
            The value to assign to the social_jit_provisioning_enabled property of this SocialIdentityProvider.
        :type social_jit_provisioning_enabled: bool

        :param jit_prov_group_static_list_enabled:
            The value to assign to the jit_prov_group_static_list_enabled property of this SocialIdentityProvider.
        :type jit_prov_group_static_list_enabled: bool

        :param jit_prov_assigned_groups:
            The value to assign to the jit_prov_assigned_groups property of this SocialIdentityProvider.
        :type jit_prov_assigned_groups: list[oci.identity_domains.models.SocialIdentityProviderJitProvAssignedGroups]

        :param registration_enabled:
            The value to assign to the registration_enabled property of this SocialIdentityProvider.
        :type registration_enabled: bool

        :param auto_redirect_enabled:
            The value to assign to the auto_redirect_enabled property of this SocialIdentityProvider.
        :type auto_redirect_enabled: bool

        :param show_on_login:
            The value to assign to the show_on_login property of this SocialIdentityProvider.
        :type show_on_login: bool

        :param status:
            The value to assign to the status property of this SocialIdentityProvider.
            Allowed values for this property are: "created", "deleted", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param id_attribute:
            The value to assign to the id_attribute property of this SocialIdentityProvider.
        :type id_attribute: str

        :param authz_url:
            The value to assign to the authz_url property of this SocialIdentityProvider.
        :type authz_url: str

        :param access_token_url:
            The value to assign to the access_token_url property of this SocialIdentityProvider.
        :type access_token_url: str

        :param profile_url:
            The value to assign to the profile_url property of this SocialIdentityProvider.
        :type profile_url: str

        :param scope:
            The value to assign to the scope property of this SocialIdentityProvider.
        :type scope: list[str]

        :param admin_scope:
            The value to assign to the admin_scope property of this SocialIdentityProvider.
        :type admin_scope: list[str]

        :param consumer_key:
            The value to assign to the consumer_key property of this SocialIdentityProvider.
        :type consumer_key: str

        :param consumer_secret:
            The value to assign to the consumer_secret property of this SocialIdentityProvider.
        :type consumer_secret: str

        :param service_provider_name:
            The value to assign to the service_provider_name property of this SocialIdentityProvider.
        :type service_provider_name: str

        :param clock_skew_in_seconds:
            The value to assign to the clock_skew_in_seconds property of this SocialIdentityProvider.
        :type clock_skew_in_seconds: int

        :param redirect_url:
            The value to assign to the redirect_url property of this SocialIdentityProvider.
        :type redirect_url: str

        :param icon_url:
            The value to assign to the icon_url property of this SocialIdentityProvider.
        :type icon_url: str

        :param discovery_url:
            The value to assign to the discovery_url property of this SocialIdentityProvider.
        :type discovery_url: str

        :param client_credential_in_payload:
            The value to assign to the client_credential_in_payload property of this SocialIdentityProvider.
        :type client_credential_in_payload: bool

        :param refresh_token_url:
            The value to assign to the refresh_token_url property of this SocialIdentityProvider.
        :type refresh_token_url: str

        :param relay_idp_param_mappings:
            The value to assign to the relay_idp_param_mappings property of this SocialIdentityProvider.
        :type relay_idp_param_mappings: list[oci.identity_domains.models.SocialIdentityProviderRelayIdpParamMappings]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'name': 'str',
            'description': 'str',
            'enabled': 'bool',
            'account_linking_enabled': 'bool',
            'social_jit_provisioning_enabled': 'bool',
            'jit_prov_group_static_list_enabled': 'bool',
            'jit_prov_assigned_groups': 'list[SocialIdentityProviderJitProvAssignedGroups]',
            'registration_enabled': 'bool',
            'auto_redirect_enabled': 'bool',
            'show_on_login': 'bool',
            'status': 'str',
            'id_attribute': 'str',
            'authz_url': 'str',
            'access_token_url': 'str',
            'profile_url': 'str',
            'scope': 'list[str]',
            'admin_scope': 'list[str]',
            'consumer_key': 'str',
            'consumer_secret': 'str',
            'service_provider_name': 'str',
            'clock_skew_in_seconds': 'int',
            'redirect_url': 'str',
            'icon_url': 'str',
            'discovery_url': 'str',
            'client_credential_in_payload': 'bool',
            'refresh_token_url': 'str',
            'relay_idp_param_mappings': 'list[SocialIdentityProviderRelayIdpParamMappings]'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'name': 'name',
            'description': 'description',
            'enabled': 'enabled',
            'account_linking_enabled': 'accountLinkingEnabled',
            'social_jit_provisioning_enabled': 'socialJitProvisioningEnabled',
            'jit_prov_group_static_list_enabled': 'jitProvGroupStaticListEnabled',
            'jit_prov_assigned_groups': 'jitProvAssignedGroups',
            'registration_enabled': 'registrationEnabled',
            'auto_redirect_enabled': 'autoRedirectEnabled',
            'show_on_login': 'showOnLogin',
            'status': 'status',
            'id_attribute': 'idAttribute',
            'authz_url': 'authzUrl',
            'access_token_url': 'accessTokenUrl',
            'profile_url': 'profileUrl',
            'scope': 'scope',
            'admin_scope': 'adminScope',
            'consumer_key': 'consumerKey',
            'consumer_secret': 'consumerSecret',
            'service_provider_name': 'serviceProviderName',
            'clock_skew_in_seconds': 'clockSkewInSeconds',
            'redirect_url': 'redirectUrl',
            'icon_url': 'iconUrl',
            'discovery_url': 'discoveryUrl',
            'client_credential_in_payload': 'clientCredentialInPayload',
            'refresh_token_url': 'refreshTokenUrl',
            'relay_idp_param_mappings': 'relayIdpParamMappings'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._name = None
        self._description = None
        self._enabled = None
        self._account_linking_enabled = None
        self._social_jit_provisioning_enabled = None
        self._jit_prov_group_static_list_enabled = None
        self._jit_prov_assigned_groups = None
        self._registration_enabled = None
        self._auto_redirect_enabled = None
        self._show_on_login = None
        self._status = None
        self._id_attribute = None
        self._authz_url = None
        self._access_token_url = None
        self._profile_url = None
        self._scope = None
        self._admin_scope = None
        self._consumer_key = None
        self._consumer_secret = None
        self._service_provider_name = None
        self._clock_skew_in_seconds = None
        self._redirect_url = None
        self._icon_url = None
        self._discovery_url = None
        self._client_credential_in_payload = None
        self._refresh_token_url = None
        self._relay_idp_param_mappings = None

    @property
    def id(self):
        """
        Gets the id of this SocialIdentityProvider.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this SocialIdentityProvider.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SocialIdentityProvider.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this SocialIdentityProvider.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this SocialIdentityProvider.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this SocialIdentityProvider.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this SocialIdentityProvider.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this SocialIdentityProvider.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this SocialIdentityProvider.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this SocialIdentityProvider.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this SocialIdentityProvider.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this SocialIdentityProvider.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this SocialIdentityProvider.

        :return: The meta of this SocialIdentityProvider.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this SocialIdentityProvider.

        :param meta: The meta of this SocialIdentityProvider.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this SocialIdentityProvider.

        :return: The idcs_created_by of this SocialIdentityProvider.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this SocialIdentityProvider.

        :param idcs_created_by: The idcs_created_by of this SocialIdentityProvider.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this SocialIdentityProvider.

        :return: The idcs_last_modified_by of this SocialIdentityProvider.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this SocialIdentityProvider.

        :param idcs_last_modified_by: The idcs_last_modified_by of this SocialIdentityProvider.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this SocialIdentityProvider.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this SocialIdentityProvider.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this SocialIdentityProvider.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this SocialIdentityProvider.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this SocialIdentityProvider.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this SocialIdentityProvider.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this SocialIdentityProvider.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this SocialIdentityProvider.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this SocialIdentityProvider.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this SocialIdentityProvider.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this SocialIdentityProvider.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this SocialIdentityProvider.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this SocialIdentityProvider.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this SocialIdentityProvider.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this SocialIdentityProvider.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this SocialIdentityProvider.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this SocialIdentityProvider.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this SocialIdentityProvider.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this SocialIdentityProvider.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this SocialIdentityProvider.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this SocialIdentityProvider.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this SocialIdentityProvider.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this SocialIdentityProvider.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this SocialIdentityProvider.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this SocialIdentityProvider.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this SocialIdentityProvider.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this SocialIdentityProvider.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SocialIdentityProvider.
        Social provider name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: global


        :return: The name of this SocialIdentityProvider.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SocialIdentityProvider.
        Social provider name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: global


        :param name: The name of this SocialIdentityProvider.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this SocialIdentityProvider.
        Social IDP description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this SocialIdentityProvider.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SocialIdentityProvider.
        Social IDP description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this SocialIdentityProvider.
        :type: str
        """
        self._description = description

    @property
    def enabled(self):
        """
        **[Required]** Gets the enabled of this SocialIdentityProvider.
        Whether the IDP is enabled or not

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this SocialIdentityProvider.
        Whether the IDP is enabled or not

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enabled: The enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._enabled = enabled

    @property
    def account_linking_enabled(self):
        """
        **[Required]** Gets the account_linking_enabled of this SocialIdentityProvider.
        Whether account linking is enabled

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The account_linking_enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._account_linking_enabled

    @account_linking_enabled.setter
    def account_linking_enabled(self, account_linking_enabled):
        """
        Sets the account_linking_enabled of this SocialIdentityProvider.
        Whether account linking is enabled

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param account_linking_enabled: The account_linking_enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._account_linking_enabled = account_linking_enabled

    @property
    def social_jit_provisioning_enabled(self):
        """
        Gets the social_jit_provisioning_enabled of this SocialIdentityProvider.
        Whether Social JIT Provisioning is enabled

        **Added In:** 2307282043

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The social_jit_provisioning_enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._social_jit_provisioning_enabled

    @social_jit_provisioning_enabled.setter
    def social_jit_provisioning_enabled(self, social_jit_provisioning_enabled):
        """
        Sets the social_jit_provisioning_enabled of this SocialIdentityProvider.
        Whether Social JIT Provisioning is enabled

        **Added In:** 2307282043

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param social_jit_provisioning_enabled: The social_jit_provisioning_enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._social_jit_provisioning_enabled = social_jit_provisioning_enabled

    @property
    def jit_prov_group_static_list_enabled(self):
        """
        Gets the jit_prov_group_static_list_enabled of this SocialIdentityProvider.
        Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 2309290043

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The jit_prov_group_static_list_enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._jit_prov_group_static_list_enabled

    @jit_prov_group_static_list_enabled.setter
    def jit_prov_group_static_list_enabled(self, jit_prov_group_static_list_enabled):
        """
        Sets the jit_prov_group_static_list_enabled of this SocialIdentityProvider.
        Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 2309290043

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param jit_prov_group_static_list_enabled: The jit_prov_group_static_list_enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._jit_prov_group_static_list_enabled = jit_prov_group_static_list_enabled

    @property
    def jit_prov_assigned_groups(self):
        """
        Gets the jit_prov_assigned_groups of this SocialIdentityProvider.
        Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

        **Added In:** 2309290043

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The jit_prov_assigned_groups of this SocialIdentityProvider.
        :rtype: list[oci.identity_domains.models.SocialIdentityProviderJitProvAssignedGroups]
        """
        return self._jit_prov_assigned_groups

    @jit_prov_assigned_groups.setter
    def jit_prov_assigned_groups(self, jit_prov_assigned_groups):
        """
        Sets the jit_prov_assigned_groups of this SocialIdentityProvider.
        Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

        **Added In:** 2309290043

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param jit_prov_assigned_groups: The jit_prov_assigned_groups of this SocialIdentityProvider.
        :type: list[oci.identity_domains.models.SocialIdentityProviderJitProvAssignedGroups]
        """
        self._jit_prov_assigned_groups = jit_prov_assigned_groups

    @property
    def registration_enabled(self):
        """
        **[Required]** Gets the registration_enabled of this SocialIdentityProvider.
        Whether registration is enabled

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The registration_enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._registration_enabled

    @registration_enabled.setter
    def registration_enabled(self, registration_enabled):
        """
        Sets the registration_enabled of this SocialIdentityProvider.
        Whether registration is enabled

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param registration_enabled: The registration_enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._registration_enabled = registration_enabled

    @property
    def auto_redirect_enabled(self):
        """
        Gets the auto_redirect_enabled of this SocialIdentityProvider.
        Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

        **Added In:** 2310202314

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The auto_redirect_enabled of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._auto_redirect_enabled

    @auto_redirect_enabled.setter
    def auto_redirect_enabled(self, auto_redirect_enabled):
        """
        Sets the auto_redirect_enabled of this SocialIdentityProvider.
        Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

        **Added In:** 2310202314

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param auto_redirect_enabled: The auto_redirect_enabled of this SocialIdentityProvider.
        :type: bool
        """
        self._auto_redirect_enabled = auto_redirect_enabled

    @property
    def show_on_login(self):
        """
        **[Required]** Gets the show_on_login of this SocialIdentityProvider.
        Whether show on login

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The show_on_login of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._show_on_login

    @show_on_login.setter
    def show_on_login(self, show_on_login):
        """
        Sets the show_on_login of this SocialIdentityProvider.
        Whether show on login

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param show_on_login: The show_on_login of this SocialIdentityProvider.
        :type: bool
        """
        self._show_on_login = show_on_login

    @property
    def status(self):
        """
        Gets the status of this SocialIdentityProvider.
        Status

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "created", "deleted", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this SocialIdentityProvider.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this SocialIdentityProvider.
        Status

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param status: The status of this SocialIdentityProvider.
        :type: str
        """
        allowed_values = ["created", "deleted"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def id_attribute(self):
        """
        Gets the id_attribute of this SocialIdentityProvider.
        Id attribute used for account linking

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The id_attribute of this SocialIdentityProvider.
        :rtype: str
        """
        return self._id_attribute

    @id_attribute.setter
    def id_attribute(self, id_attribute):
        """
        Sets the id_attribute of this SocialIdentityProvider.
        Id attribute used for account linking

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param id_attribute: The id_attribute of this SocialIdentityProvider.
        :type: str
        """
        self._id_attribute = id_attribute

    @property
    def authz_url(self):
        """
        Gets the authz_url of this SocialIdentityProvider.
        Social IDP Authorization URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The authz_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._authz_url

    @authz_url.setter
    def authz_url(self, authz_url):
        """
        Sets the authz_url of this SocialIdentityProvider.
        Social IDP Authorization URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param authz_url: The authz_url of this SocialIdentityProvider.
        :type: str
        """
        self._authz_url = authz_url

    @property
    def access_token_url(self):
        """
        Gets the access_token_url of this SocialIdentityProvider.
        Social IDP Access token URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The access_token_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._access_token_url

    @access_token_url.setter
    def access_token_url(self, access_token_url):
        """
        Sets the access_token_url of this SocialIdentityProvider.
        Social IDP Access token URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param access_token_url: The access_token_url of this SocialIdentityProvider.
        :type: str
        """
        self._access_token_url = access_token_url

    @property
    def profile_url(self):
        """
        Gets the profile_url of this SocialIdentityProvider.
        Social IDP User profile URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The profile_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._profile_url

    @profile_url.setter
    def profile_url(self, profile_url):
        """
        Sets the profile_url of this SocialIdentityProvider.
        Social IDP User profile URL

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param profile_url: The profile_url of this SocialIdentityProvider.
        :type: str
        """
        self._profile_url = profile_url

    @property
    def scope(self):
        """
        Gets the scope of this SocialIdentityProvider.
        Scope to request

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The scope of this SocialIdentityProvider.
        :rtype: list[str]
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this SocialIdentityProvider.
        Scope to request

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param scope: The scope of this SocialIdentityProvider.
        :type: list[str]
        """
        self._scope = scope

    @property
    def admin_scope(self):
        """
        Gets the admin_scope of this SocialIdentityProvider.
        Admin scope to request

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The admin_scope of this SocialIdentityProvider.
        :rtype: list[str]
        """
        return self._admin_scope

    @admin_scope.setter
    def admin_scope(self, admin_scope):
        """
        Sets the admin_scope of this SocialIdentityProvider.
        Admin scope to request

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param admin_scope: The admin_scope of this SocialIdentityProvider.
        :type: list[str]
        """
        self._admin_scope = admin_scope

    @property
    def consumer_key(self):
        """
        **[Required]** Gets the consumer_key of this SocialIdentityProvider.
        Social IDP Client Application Client ID

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The consumer_key of this SocialIdentityProvider.
        :rtype: str
        """
        return self._consumer_key

    @consumer_key.setter
    def consumer_key(self, consumer_key):
        """
        Sets the consumer_key of this SocialIdentityProvider.
        Social IDP Client Application Client ID

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param consumer_key: The consumer_key of this SocialIdentityProvider.
        :type: str
        """
        self._consumer_key = consumer_key

    @property
    def consumer_secret(self):
        """
        **[Required]** Gets the consumer_secret of this SocialIdentityProvider.
        Social IDP Client Application Client Secret

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsSensitive: encrypt
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The consumer_secret of this SocialIdentityProvider.
        :rtype: str
        """
        return self._consumer_secret

    @consumer_secret.setter
    def consumer_secret(self, consumer_secret):
        """
        Sets the consumer_secret of this SocialIdentityProvider.
        Social IDP Client Application Client Secret

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsSensitive: encrypt
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param consumer_secret: The consumer_secret of this SocialIdentityProvider.
        :type: str
        """
        self._consumer_secret = consumer_secret

    @property
    def service_provider_name(self):
        """
        **[Required]** Gets the service_provider_name of this SocialIdentityProvider.
        Service Provider Name

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The service_provider_name of this SocialIdentityProvider.
        :rtype: str
        """
        return self._service_provider_name

    @service_provider_name.setter
    def service_provider_name(self, service_provider_name):
        """
        Sets the service_provider_name of this SocialIdentityProvider.
        Service Provider Name

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param service_provider_name: The service_provider_name of this SocialIdentityProvider.
        :type: str
        """
        self._service_provider_name = service_provider_name

    @property
    def clock_skew_in_seconds(self):
        """
        Gets the clock_skew_in_seconds of this SocialIdentityProvider.
        Social IDP allowed clock skew time

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The clock_skew_in_seconds of this SocialIdentityProvider.
        :rtype: int
        """
        return self._clock_skew_in_seconds

    @clock_skew_in_seconds.setter
    def clock_skew_in_seconds(self, clock_skew_in_seconds):
        """
        Sets the clock_skew_in_seconds of this SocialIdentityProvider.
        Social IDP allowed clock skew time

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param clock_skew_in_seconds: The clock_skew_in_seconds of this SocialIdentityProvider.
        :type: int
        """
        self._clock_skew_in_seconds = clock_skew_in_seconds

    @property
    def redirect_url(self):
        """
        Gets the redirect_url of this SocialIdentityProvider.
        redirect URL for social idp

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The redirect_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this SocialIdentityProvider.
        redirect URL for social idp

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param redirect_url: The redirect_url of this SocialIdentityProvider.
        :type: str
        """
        self._redirect_url = redirect_url

    @property
    def icon_url(self):
        """
        Gets the icon_url of this SocialIdentityProvider.
        ICON URL for social idp

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The icon_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._icon_url

    @icon_url.setter
    def icon_url(self, icon_url):
        """
        Sets the icon_url of this SocialIdentityProvider.
        ICON URL for social idp

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param icon_url: The icon_url of this SocialIdentityProvider.
        :type: str
        """
        self._icon_url = icon_url

    @property
    def discovery_url(self):
        """
        Gets the discovery_url of this SocialIdentityProvider.
        Discovery URL

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The discovery_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._discovery_url

    @discovery_url.setter
    def discovery_url(self, discovery_url):
        """
        Sets the discovery_url of this SocialIdentityProvider.
        Discovery URL

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param discovery_url: The discovery_url of this SocialIdentityProvider.
        :type: str
        """
        self._discovery_url = discovery_url

    @property
    def client_credential_in_payload(self):
        """
        Gets the client_credential_in_payload of this SocialIdentityProvider.
        Whether the client credential is contained in payload

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The client_credential_in_payload of this SocialIdentityProvider.
        :rtype: bool
        """
        return self._client_credential_in_payload

    @client_credential_in_payload.setter
    def client_credential_in_payload(self, client_credential_in_payload):
        """
        Sets the client_credential_in_payload of this SocialIdentityProvider.
        Whether the client credential is contained in payload

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param client_credential_in_payload: The client_credential_in_payload of this SocialIdentityProvider.
        :type: bool
        """
        self._client_credential_in_payload = client_credential_in_payload

    @property
    def refresh_token_url(self):
        """
        Gets the refresh_token_url of this SocialIdentityProvider.
        Social IDP Refresh token URL

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The refresh_token_url of this SocialIdentityProvider.
        :rtype: str
        """
        return self._refresh_token_url

    @refresh_token_url.setter
    def refresh_token_url(self, refresh_token_url):
        """
        Sets the refresh_token_url of this SocialIdentityProvider.
        Social IDP Refresh token URL

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param refresh_token_url: The refresh_token_url of this SocialIdentityProvider.
        :type: str
        """
        self._refresh_token_url = refresh_token_url

    @property
    def relay_idp_param_mappings(self):
        """
        Gets the relay_idp_param_mappings of this SocialIdentityProvider.
        Relay Param variable for Social IDP

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - idcsCompositeKey: [relayParamKey]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The relay_idp_param_mappings of this SocialIdentityProvider.
        :rtype: list[oci.identity_domains.models.SocialIdentityProviderRelayIdpParamMappings]
        """
        return self._relay_idp_param_mappings

    @relay_idp_param_mappings.setter
    def relay_idp_param_mappings(self, relay_idp_param_mappings):
        """
        Sets the relay_idp_param_mappings of this SocialIdentityProvider.
        Relay Param variable for Social IDP

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - idcsCompositeKey: [relayParamKey]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param relay_idp_param_mappings: The relay_idp_param_mappings of this SocialIdentityProvider.
        :type: list[oci.identity_domains.models.SocialIdentityProviderRelayIdpParamMappings]
        """
        self._relay_idp_param_mappings = relay_idp_param_mappings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
