# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataRetentionPeriodsInDays(object):
    """
    Data Retention periods
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataRetentionPeriodsInDays object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param raw_data:
            The value to assign to the raw_data property of this DataRetentionPeriodsInDays.
        :type raw_data: int

        :param rejected_data:
            The value to assign to the rejected_data property of this DataRetentionPeriodsInDays.
        :type rejected_data: int

        :param historized_data:
            The value to assign to the historized_data property of this DataRetentionPeriodsInDays.
        :type historized_data: int

        :param raw_command_data:
            The value to assign to the raw_command_data property of this DataRetentionPeriodsInDays.
        :type raw_command_data: int

        """
        self.swagger_types = {
            'raw_data': 'int',
            'rejected_data': 'int',
            'historized_data': 'int',
            'raw_command_data': 'int'
        }
        self.attribute_map = {
            'raw_data': 'rawData',
            'rejected_data': 'rejectedData',
            'historized_data': 'historizedData',
            'raw_command_data': 'rawCommandData'
        }
        self._raw_data = None
        self._rejected_data = None
        self._historized_data = None
        self._raw_command_data = None

    @property
    def raw_data(self):
        """
        **[Required]** Gets the raw_data of this DataRetentionPeriodsInDays.
        Number of days for which any raw data sent to IoT devices would be retained for.


        :return: The raw_data of this DataRetentionPeriodsInDays.
        :rtype: int
        """
        return self._raw_data

    @raw_data.setter
    def raw_data(self, raw_data):
        """
        Sets the raw_data of this DataRetentionPeriodsInDays.
        Number of days for which any raw data sent to IoT devices would be retained for.


        :param raw_data: The raw_data of this DataRetentionPeriodsInDays.
        :type: int
        """
        self._raw_data = raw_data

    @property
    def rejected_data(self):
        """
        **[Required]** Gets the rejected_data of this DataRetentionPeriodsInDays.
        Number of days for which any data sent to IoT devices would be retained for.


        :return: The rejected_data of this DataRetentionPeriodsInDays.
        :rtype: int
        """
        return self._rejected_data

    @rejected_data.setter
    def rejected_data(self, rejected_data):
        """
        Sets the rejected_data of this DataRetentionPeriodsInDays.
        Number of days for which any data sent to IoT devices would be retained for.


        :param rejected_data: The rejected_data of this DataRetentionPeriodsInDays.
        :type: int
        """
        self._rejected_data = rejected_data

    @property
    def historized_data(self):
        """
        **[Required]** Gets the historized_data of this DataRetentionPeriodsInDays.
        Number of days for which any normalized data sent to IoT devices would be retained for.


        :return: The historized_data of this DataRetentionPeriodsInDays.
        :rtype: int
        """
        return self._historized_data

    @historized_data.setter
    def historized_data(self, historized_data):
        """
        Sets the historized_data of this DataRetentionPeriodsInDays.
        Number of days for which any normalized data sent to IoT devices would be retained for.


        :param historized_data: The historized_data of this DataRetentionPeriodsInDays.
        :type: int
        """
        self._historized_data = historized_data

    @property
    def raw_command_data(self):
        """
        **[Required]** Gets the raw_command_data of this DataRetentionPeriodsInDays.
        Number of days for which any raw command data sent to IoT devices would be retained for.


        :return: The raw_command_data of this DataRetentionPeriodsInDays.
        :rtype: int
        """
        return self._raw_command_data

    @raw_command_data.setter
    def raw_command_data(self, raw_command_data):
        """
        Sets the raw_command_data of this DataRetentionPeriodsInDays.
        Number of days for which any raw command data sent to IoT devices would be retained for.


        :param raw_command_data: The raw_command_data of this DataRetentionPeriodsInDays.
        :type: int
        """
        self._raw_command_data = raw_command_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
