# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521

from .work_item_details import WorkItemDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaMigrationWorkItemDetails(WorkItemDetails):
    """
    The java migration work item details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JavaMigrationWorkItemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.jms_utils.models.JavaMigrationWorkItemDetails.kind` attribute
        of this class is ``JAVA_MIGRATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this JavaMigrationWorkItemDetails.
            Allowed values for this property are: "BASIC", "JAVA_MIGRATION", "PERFORMANCE_TUNING"
        :type kind: str

        :param work_item_type:
            The value to assign to the work_item_type property of this JavaMigrationWorkItemDetails.
            Allowed values for this property are: "PERFORMANCE_TUNING", "JAVA_MIGRATION"
        :type work_item_type: str

        :param target_jdk_version:
            The value to assign to the target_jdk_version property of this JavaMigrationWorkItemDetails.
        :type target_jdk_version: str

        :param input_applications_object_storage_paths:
            The value to assign to the input_applications_object_storage_paths property of this JavaMigrationWorkItemDetails.
        :type input_applications_object_storage_paths: str

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this JavaMigrationWorkItemDetails.
        :type analysis_project_name: str

        """
        self.swagger_types = {
            'kind': 'str',
            'work_item_type': 'str',
            'target_jdk_version': 'str',
            'input_applications_object_storage_paths': 'str',
            'analysis_project_name': 'str'
        }
        self.attribute_map = {
            'kind': 'kind',
            'work_item_type': 'workItemType',
            'target_jdk_version': 'targetJdkVersion',
            'input_applications_object_storage_paths': 'inputApplicationsObjectStoragePaths',
            'analysis_project_name': 'analysisProjectName'
        }
        self._kind = None
        self._work_item_type = None
        self._target_jdk_version = None
        self._input_applications_object_storage_paths = None
        self._analysis_project_name = None
        self._kind = 'JAVA_MIGRATION'

    @property
    def target_jdk_version(self):
        """
        **[Required]** Gets the target_jdk_version of this JavaMigrationWorkItemDetails.
        The JDK version against which the migration analysis was performed to identify effort required to move from source JDK.


        :return: The target_jdk_version of this JavaMigrationWorkItemDetails.
        :rtype: str
        """
        return self._target_jdk_version

    @target_jdk_version.setter
    def target_jdk_version(self, target_jdk_version):
        """
        Sets the target_jdk_version of this JavaMigrationWorkItemDetails.
        The JDK version against which the migration analysis was performed to identify effort required to move from source JDK.


        :param target_jdk_version: The target_jdk_version of this JavaMigrationWorkItemDetails.
        :type: str
        """
        self._target_jdk_version = target_jdk_version

    @property
    def input_applications_object_storage_paths(self):
        """
        **[Required]** Gets the input_applications_object_storage_paths of this JavaMigrationWorkItemDetails.
        Object storage path to the input artifact/s in the form of a serialized array.
        Example: \"[\\\"/JMS/Utils/myartifacts1.jar\\\",\\\"/JMS/Utils/myartifacts2.war\\\"]\"


        :return: The input_applications_object_storage_paths of this JavaMigrationWorkItemDetails.
        :rtype: str
        """
        return self._input_applications_object_storage_paths

    @input_applications_object_storage_paths.setter
    def input_applications_object_storage_paths(self, input_applications_object_storage_paths):
        """
        Sets the input_applications_object_storage_paths of this JavaMigrationWorkItemDetails.
        Object storage path to the input artifact/s in the form of a serialized array.
        Example: \"[\\\"/JMS/Utils/myartifacts1.jar\\\",\\\"/JMS/Utils/myartifacts2.war\\\"]\"


        :param input_applications_object_storage_paths: The input_applications_object_storage_paths of this JavaMigrationWorkItemDetails.
        :type: str
        """
        self._input_applications_object_storage_paths = input_applications_object_storage_paths

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this JavaMigrationWorkItemDetails.
        Name of the analysis project.


        :return: The analysis_project_name of this JavaMigrationWorkItemDetails.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this JavaMigrationWorkItemDetails.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this JavaMigrationWorkItemDetails.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
