# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateNamedCredentialDetails(object):
    """
    A representation of a named credential subresource for the Management Agent resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateNamedCredentialDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateNamedCredentialDetails.
        :type name: str

        :param type:
            The value to assign to the type property of this CreateNamedCredentialDetails.
        :type type: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this CreateNamedCredentialDetails.
        :type management_agent_id: str

        :param description:
            The value to assign to the description property of this CreateNamedCredentialDetails.
        :type description: str

        :param properties:
            The value to assign to the properties property of this CreateNamedCredentialDetails.
        :type properties: list[oci.management_agent.models.NamedCredentialProperty]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateNamedCredentialDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateNamedCredentialDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'management_agent_id': 'str',
            'description': 'str',
            'properties': 'list[NamedCredentialProperty]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'management_agent_id': 'managementAgentId',
            'description': 'description',
            'properties': 'properties',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._name = None
        self._type = None
        self._management_agent_id = None
        self._description = None
        self._properties = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateNamedCredentialDetails.
        Identifier for Named Credential. This is unique for the Management Agent.


        :return: The name of this CreateNamedCredentialDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateNamedCredentialDetails.
        Identifier for Named Credential. This is unique for the Management Agent.


        :param name: The name of this CreateNamedCredentialDetails.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateNamedCredentialDetails.
        The type of the Named Credential.


        :return: The type of this CreateNamedCredentialDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateNamedCredentialDetails.
        The type of the Named Credential.


        :param type: The type of this CreateNamedCredentialDetails.
        :type: str
        """
        self._type = type

    @property
    def management_agent_id(self):
        """
        **[Required]** Gets the management_agent_id of this CreateNamedCredentialDetails.
        The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.


        :return: The management_agent_id of this CreateNamedCredentialDetails.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this CreateNamedCredentialDetails.
        The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.


        :param management_agent_id: The management_agent_id of this CreateNamedCredentialDetails.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def description(self):
        """
        Gets the description of this CreateNamedCredentialDetails.
        Description of the Named Credential.


        :return: The description of this CreateNamedCredentialDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateNamedCredentialDetails.
        Description of the Named Credential.


        :param description: The description of this CreateNamedCredentialDetails.
        :type: str
        """
        self._description = description

    @property
    def properties(self):
        """
        **[Required]** Gets the properties of this CreateNamedCredentialDetails.
        Properties for the named credential


        :return: The properties of this CreateNamedCredentialDetails.
        :rtype: list[oci.management_agent.models.NamedCredentialProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CreateNamedCredentialDetails.
        Properties for the named credential


        :param properties: The properties of this CreateNamedCredentialDetails.
        :type: list[oci.management_agent.models.NamedCredentialProperty]
        """
        self._properties = properties

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateNamedCredentialDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateNamedCredentialDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateNamedCredentialDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateNamedCredentialDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateNamedCredentialDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateNamedCredentialDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateNamedCredentialDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateNamedCredentialDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
