# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedShapeSummary(object):
    """
    Summary of the database system shape.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedShapeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape:
            The value to assign to the shape property of this SupportedShapeSummary.
        :type shape: str

        :param is_flexible:
            The value to assign to the is_flexible property of this SupportedShapeSummary.
        :type is_flexible: bool

        :param ocpu_options:
            The value to assign to the ocpu_options property of this SupportedShapeSummary.
        :type ocpu_options: oci.marketplace_publisher.models.ShapeOcpuOptions

        :param memory_options:
            The value to assign to the memory_options property of this SupportedShapeSummary.
        :type memory_options: oci.marketplace_publisher.models.ShapeMemoryOptions

        """
        self.swagger_types = {
            'shape': 'str',
            'is_flexible': 'bool',
            'ocpu_options': 'ShapeOcpuOptions',
            'memory_options': 'ShapeMemoryOptions'
        }
        self.attribute_map = {
            'shape': 'shape',
            'is_flexible': 'isFlexible',
            'ocpu_options': 'ocpuOptions',
            'memory_options': 'memoryOptions'
        }
        self._shape = None
        self._is_flexible = None
        self._ocpu_options = None
        self._memory_options = None

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this SupportedShapeSummary.
        The name of the Compute VM shape.
        Example: `VM.Standard.E4.Flex`


        :return: The shape of this SupportedShapeSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this SupportedShapeSummary.
        The name of the Compute VM shape.
        Example: `VM.Standard.E4.Flex`


        :param shape: The shape of this SupportedShapeSummary.
        :type: str
        """
        self._shape = shape

    @property
    def is_flexible(self):
        """
        **[Required]** Gets the is_flexible of this SupportedShapeSummary.
        Indicates if the shape is a flex shape.


        :return: The is_flexible of this SupportedShapeSummary.
        :rtype: bool
        """
        return self._is_flexible

    @is_flexible.setter
    def is_flexible(self, is_flexible):
        """
        Sets the is_flexible of this SupportedShapeSummary.
        Indicates if the shape is a flex shape.


        :param is_flexible: The is_flexible of this SupportedShapeSummary.
        :type: bool
        """
        self._is_flexible = is_flexible

    @property
    def ocpu_options(self):
        """
        Gets the ocpu_options of this SupportedShapeSummary.

        :return: The ocpu_options of this SupportedShapeSummary.
        :rtype: oci.marketplace_publisher.models.ShapeOcpuOptions
        """
        return self._ocpu_options

    @ocpu_options.setter
    def ocpu_options(self, ocpu_options):
        """
        Sets the ocpu_options of this SupportedShapeSummary.

        :param ocpu_options: The ocpu_options of this SupportedShapeSummary.
        :type: oci.marketplace_publisher.models.ShapeOcpuOptions
        """
        self._ocpu_options = ocpu_options

    @property
    def memory_options(self):
        """
        Gets the memory_options of this SupportedShapeSummary.

        :return: The memory_options of this SupportedShapeSummary.
        :rtype: oci.marketplace_publisher.models.ShapeMemoryOptions
        """
        return self._memory_options

    @memory_options.setter
    def memory_options(self, memory_options):
        """
        Sets the memory_options of this SupportedShapeSummary.

        :param memory_options: The memory_options of this SupportedShapeSummary.
        :type: oci.marketplace_publisher.models.ShapeMemoryOptions
        """
        self._memory_options = memory_options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
