# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MacOrder(object):
    """
    A description of a MacOrder resource.
    """

    #: A constant which can be used with the shape property of a MacOrder.
    #: This constant has a value of "M2_PRO_MAC_MINI_32GB_1TB"
    SHAPE_M2_PRO_MAC_MINI_32_GB_1_TB = "M2_PRO_MAC_MINI_32GB_1TB"

    #: A constant which can be used with the shape property of a MacOrder.
    #: This constant has a value of "M2_ULTRA_MAC_STUDIO_64GB_4TB"
    SHAPE_M2_ULTRA_MAC_STUDIO_64_GB_4_TB = "M2_ULTRA_MAC_STUDIO_64GB_4TB"

    #: A constant which can be used with the shape property of a MacOrder.
    #: This constant has a value of "M2_ULTRA_MAC_STUDIO_192GB_4TB"
    SHAPE_M2_ULTRA_MAC_STUDIO_192_GB_4_TB = "M2_ULTRA_MAC_STUDIO_192GB_4TB"

    #: A constant which can be used with the shape property of a MacOrder.
    #: This constant has a value of "M4_PRO_MAC_MINI_64GB_2TB"
    SHAPE_M4_PRO_MAC_MINI_64_GB_2_TB = "M4_PRO_MAC_MINI_64GB_2TB"

    #: A constant which can be used with the shape property of a MacOrder.
    #: This constant has a value of "M4_PRO_MAC_MINI_64GB_4TB"
    SHAPE_M4_PRO_MAC_MINI_64_GB_4_TB = "M4_PRO_MAC_MINI_64GB_4TB"

    #: A constant which can be used with the commitment_term property of a MacOrder.
    #: This constant has a value of "YEARS_3"
    COMMITMENT_TERM_YEARS_3 = "YEARS_3"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "SUBMITTED"
    ORDER_STATUS_SUBMITTED = "SUBMITTED"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "PENDING_DOCUSIGN"
    ORDER_STATUS_PENDING_DOCUSIGN = "PENDING_DOCUSIGN"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "ORDER_REVIEW"
    ORDER_STATUS_ORDER_REVIEW = "ORDER_REVIEW"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "CUSTOMER_REVIEW"
    ORDER_STATUS_CUSTOMER_REVIEW = "CUSTOMER_REVIEW"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "CUSTOMER_APPROVED"
    ORDER_STATUS_CUSTOMER_APPROVED = "CUSTOMER_APPROVED"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "FUNDING_APPROVED"
    ORDER_STATUS_FUNDING_APPROVED = "FUNDING_APPROVED"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "PROVISIONING"
    ORDER_STATUS_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "CUSTOMER_ACCEPTED"
    ORDER_STATUS_CUSTOMER_ACCEPTED = "CUSTOMER_ACCEPTED"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "COMPLETED"
    ORDER_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the order_status property of a MacOrder.
    #: This constant has a value of "CANCELED"
    ORDER_STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a MacOrder.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new MacOrder object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MacOrder.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MacOrder.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this MacOrder.
        :type display_name: str

        :param order_description:
            The value to assign to the order_description property of this MacOrder.
        :type order_description: str

        :param order_size:
            The value to assign to the order_size property of this MacOrder.
        :type order_size: int

        :param ip_range:
            The value to assign to the ip_range property of this MacOrder.
        :type ip_range: str

        :param is_docusigned:
            The value to assign to the is_docusigned property of this MacOrder.
        :type is_docusigned: bool

        :param shape:
            The value to assign to the shape property of this MacOrder.
            Allowed values for this property are: "M2_PRO_MAC_MINI_32GB_1TB", "M2_ULTRA_MAC_STUDIO_64GB_4TB", "M2_ULTRA_MAC_STUDIO_192GB_4TB", "M4_PRO_MAC_MINI_64GB_2TB", "M4_PRO_MAC_MINI_64GB_4TB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type shape: str

        :param time_created:
            The value to assign to the time_created property of this MacOrder.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MacOrder.
        :type time_updated: datetime

        :param commitment_term:
            The value to assign to the commitment_term property of this MacOrder.
            Allowed values for this property are: "YEARS_3", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type commitment_term: str

        :param time_billing_started:
            The value to assign to the time_billing_started property of this MacOrder.
        :type time_billing_started: datetime

        :param time_billing_ended:
            The value to assign to the time_billing_ended property of this MacOrder.
        :type time_billing_ended: datetime

        :param order_status:
            The value to assign to the order_status property of this MacOrder.
            Allowed values for this property are: "SUBMITTED", "PENDING_DOCUSIGN", "ORDER_REVIEW", "CUSTOMER_REVIEW", "CUSTOMER_APPROVED", "FUNDING_APPROVED", "PROVISIONING", "CUSTOMER_ACCEPTED", "COMPLETED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type order_status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MacOrder.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this MacOrder.
        :type lifecycle_details: str

        :param cancel_reason:
            The value to assign to the cancel_reason property of this MacOrder.
        :type cancel_reason: str

        :param time_canceled:
            The value to assign to the time_canceled property of this MacOrder.
        :type time_canceled: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'order_description': 'str',
            'order_size': 'int',
            'ip_range': 'str',
            'is_docusigned': 'bool',
            'shape': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'commitment_term': 'str',
            'time_billing_started': 'datetime',
            'time_billing_ended': 'datetime',
            'order_status': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'cancel_reason': 'str',
            'time_canceled': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'order_description': 'orderDescription',
            'order_size': 'orderSize',
            'ip_range': 'ipRange',
            'is_docusigned': 'isDocusigned',
            'shape': 'shape',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'commitment_term': 'commitmentTerm',
            'time_billing_started': 'timeBillingStarted',
            'time_billing_ended': 'timeBillingEnded',
            'order_status': 'orderStatus',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'cancel_reason': 'cancelReason',
            'time_canceled': 'timeCanceled'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._order_description = None
        self._order_size = None
        self._ip_range = None
        self._is_docusigned = None
        self._shape = None
        self._time_created = None
        self._time_updated = None
        self._commitment_term = None
        self._time_billing_started = None
        self._time_billing_ended = None
        self._order_status = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._cancel_reason = None
        self._time_canceled = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MacOrder.
        The OCID of the resource.


        :return: The id of this MacOrder.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MacOrder.
        The OCID of the resource.


        :param id: The id of this MacOrder.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this MacOrder.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this MacOrder.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MacOrder.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this MacOrder.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this MacOrder.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this MacOrder.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MacOrder.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this MacOrder.
        :type: str
        """
        self._display_name = display_name

    @property
    def order_description(self):
        """
        **[Required]** Gets the order_description of this MacOrder.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The order_description of this MacOrder.
        :rtype: str
        """
        return self._order_description

    @order_description.setter
    def order_description(self, order_description):
        """
        Sets the order_description of this MacOrder.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param order_description: The order_description of this MacOrder.
        :type: str
        """
        self._order_description = order_description

    @property
    def order_size(self):
        """
        **[Required]** Gets the order_size of this MacOrder.
        Number of macs requested in this MacOrder.


        :return: The order_size of this MacOrder.
        :rtype: int
        """
        return self._order_size

    @order_size.setter
    def order_size(self, order_size):
        """
        Sets the order_size of this MacOrder.
        Number of macs requested in this MacOrder.


        :param order_size: The order_size of this MacOrder.
        :type: int
        """
        self._order_size = order_size

    @property
    def ip_range(self):
        """
        Gets the ip_range of this MacOrder.
        The IP Range specified by the customer for this order.


        :return: The ip_range of this MacOrder.
        :rtype: str
        """
        return self._ip_range

    @ip_range.setter
    def ip_range(self, ip_range):
        """
        Sets the ip_range of this MacOrder.
        The IP Range specified by the customer for this order.


        :param ip_range: The ip_range of this MacOrder.
        :type: str
        """
        self._ip_range = ip_range

    @property
    def is_docusigned(self):
        """
        **[Required]** Gets the is_docusigned of this MacOrder.
        Checkbox value that indicates whether the customer completed docusign process.


        :return: The is_docusigned of this MacOrder.
        :rtype: bool
        """
        return self._is_docusigned

    @is_docusigned.setter
    def is_docusigned(self, is_docusigned):
        """
        Sets the is_docusigned of this MacOrder.
        Checkbox value that indicates whether the customer completed docusign process.


        :param is_docusigned: The is_docusigned of this MacOrder.
        :type: bool
        """
        self._is_docusigned = is_docusigned

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this MacOrder.
        Enum indicating the requested shape for the MacDevices.

        Allowed values for this property are: "M2_PRO_MAC_MINI_32GB_1TB", "M2_ULTRA_MAC_STUDIO_64GB_4TB", "M2_ULTRA_MAC_STUDIO_192GB_4TB", "M4_PRO_MAC_MINI_64GB_2TB", "M4_PRO_MAC_MINI_64GB_4TB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The shape of this MacOrder.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this MacOrder.
        Enum indicating the requested shape for the MacDevices.


        :param shape: The shape of this MacOrder.
        :type: str
        """
        allowed_values = ["M2_PRO_MAC_MINI_32GB_1TB", "M2_ULTRA_MAC_STUDIO_64GB_4TB", "M2_ULTRA_MAC_STUDIO_192GB_4TB", "M4_PRO_MAC_MINI_64GB_2TB", "M4_PRO_MAC_MINI_64GB_4TB"]
        if not value_allowed_none_or_none_sentinel(shape, allowed_values):
            shape = 'UNKNOWN_ENUM_VALUE'
        self._shape = shape

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MacOrder.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this MacOrder.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MacOrder.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this MacOrder.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this MacOrder.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this MacOrder.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MacOrder.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this MacOrder.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def commitment_term(self):
        """
        **[Required]** Gets the commitment_term of this MacOrder.
        Enum indicating the agreed commitment term for the requested MacDevices.

        Allowed values for this property are: "YEARS_3", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The commitment_term of this MacOrder.
        :rtype: str
        """
        return self._commitment_term

    @commitment_term.setter
    def commitment_term(self, commitment_term):
        """
        Sets the commitment_term of this MacOrder.
        Enum indicating the agreed commitment term for the requested MacDevices.


        :param commitment_term: The commitment_term of this MacOrder.
        :type: str
        """
        allowed_values = ["YEARS_3"]
        if not value_allowed_none_or_none_sentinel(commitment_term, allowed_values):
            commitment_term = 'UNKNOWN_ENUM_VALUE'
        self._commitment_term = commitment_term

    @property
    def time_billing_started(self):
        """
        Gets the time_billing_started of this MacOrder.
        An RFC3339-formatted datetime string containing the date and time that billing for this MacOrder begins.


        :return: The time_billing_started of this MacOrder.
        :rtype: datetime
        """
        return self._time_billing_started

    @time_billing_started.setter
    def time_billing_started(self, time_billing_started):
        """
        Sets the time_billing_started of this MacOrder.
        An RFC3339-formatted datetime string containing the date and time that billing for this MacOrder begins.


        :param time_billing_started: The time_billing_started of this MacOrder.
        :type: datetime
        """
        self._time_billing_started = time_billing_started

    @property
    def time_billing_ended(self):
        """
        Gets the time_billing_ended of this MacOrder.
        An RFC3339-formatted datetime string containing the date and time that billing for this MacOrder ends.


        :return: The time_billing_ended of this MacOrder.
        :rtype: datetime
        """
        return self._time_billing_ended

    @time_billing_ended.setter
    def time_billing_ended(self, time_billing_ended):
        """
        Sets the time_billing_ended of this MacOrder.
        An RFC3339-formatted datetime string containing the date and time that billing for this MacOrder ends.


        :param time_billing_ended: The time_billing_ended of this MacOrder.
        :type: datetime
        """
        self._time_billing_ended = time_billing_ended

    @property
    def order_status(self):
        """
        **[Required]** Gets the order_status of this MacOrder.
        The current status of the MacOrder.

        Allowed values for this property are: "SUBMITTED", "PENDING_DOCUSIGN", "ORDER_REVIEW", "CUSTOMER_REVIEW", "CUSTOMER_APPROVED", "FUNDING_APPROVED", "PROVISIONING", "CUSTOMER_ACCEPTED", "COMPLETED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The order_status of this MacOrder.
        :rtype: str
        """
        return self._order_status

    @order_status.setter
    def order_status(self, order_status):
        """
        Sets the order_status of this MacOrder.
        The current status of the MacOrder.


        :param order_status: The order_status of this MacOrder.
        :type: str
        """
        allowed_values = ["SUBMITTED", "PENDING_DOCUSIGN", "ORDER_REVIEW", "CUSTOMER_REVIEW", "CUSTOMER_APPROVED", "FUNDING_APPROVED", "PROVISIONING", "CUSTOMER_ACCEPTED", "COMPLETED", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(order_status, allowed_values):
            order_status = 'UNKNOWN_ENUM_VALUE'
        self._order_status = order_status

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this MacOrder.
        The current state of the MacOrder.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this MacOrder.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MacOrder.
        The current state of the MacOrder.


        :param lifecycle_state: The lifecycle_state of this MacOrder.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this MacOrder.
        A message that describes the current state of the MacOrder in more detail.


        :return: The lifecycle_details of this MacOrder.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this MacOrder.
        A message that describes the current state of the MacOrder in more detail.


        :param lifecycle_details: The lifecycle_details of this MacOrder.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def cancel_reason(self):
        """
        Gets the cancel_reason of this MacOrder.
        The reason for the MacOrder cancellation.


        :return: The cancel_reason of this MacOrder.
        :rtype: str
        """
        return self._cancel_reason

    @cancel_reason.setter
    def cancel_reason(self, cancel_reason):
        """
        Sets the cancel_reason of this MacOrder.
        The reason for the MacOrder cancellation.


        :param cancel_reason: The cancel_reason of this MacOrder.
        :type: str
        """
        self._cancel_reason = cancel_reason

    @property
    def time_canceled(self):
        """
        Gets the time_canceled of this MacOrder.
        An RFC3339-formatted datetime string containing the time this MacOrder was cancelled.


        :return: The time_canceled of this MacOrder.
        :rtype: datetime
        """
        return self._time_canceled

    @time_canceled.setter
    def time_canceled(self, time_canceled):
        """
        Sets the time_canceled of this MacOrder.
        An RFC3339-formatted datetime string containing the time this MacOrder was cancelled.


        :param time_canceled: The time_canceled of this MacOrder.
        :type: datetime
        """
        self._time_canceled = time_canceled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
