# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateBackupDetails(object):
    """
    Details required to validate backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_prepared_backup_required:
            The value to assign to the is_prepared_backup_required property of this ValidateBackupDetails.
        :type is_prepared_backup_required: bool

        """
        self.swagger_types = {
            'is_prepared_backup_required': 'bool'
        }
        self.attribute_map = {
            'is_prepared_backup_required': 'isPreparedBackupRequired'
        }
        self._is_prepared_backup_required = None

    @property
    def is_prepared_backup_required(self):
        """
        **[Required]** Gets the is_prepared_backup_required of this ValidateBackupDetails.
        Specifies whether the backup needs to be prepared for fast restore or not.
        Set to true to prepare the backup, set to false (default) if not required.
        Note: The prepared backup will replace the original backup and will not generate a new backup copy.
        The cost associated with the backup may vary, as the prepared backup will consistently be a full backup,
        it may also change the storage size of the original backup.


        :return: The is_prepared_backup_required of this ValidateBackupDetails.
        :rtype: bool
        """
        return self._is_prepared_backup_required

    @is_prepared_backup_required.setter
    def is_prepared_backup_required(self, is_prepared_backup_required):
        """
        Sets the is_prepared_backup_required of this ValidateBackupDetails.
        Specifies whether the backup needs to be prepared for fast restore or not.
        Set to true to prepare the backup, set to false (default) if not required.
        Note: The prepared backup will replace the original backup and will not generate a new backup copy.
        The cost associated with the backup may vary, as the prepared backup will consistently be a full backup,
        it may also change the storage size of the original backup.


        :param is_prepared_backup_required: The is_prepared_backup_required of this ValidateBackupDetails.
        :type: bool
        """
        self._is_prepared_backup_required = is_prepared_backup_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
