# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MappedSecretSummary(object):
    """
    Mapped secret used on the firewall policy rules.
    """

    #: A constant which can be used with the type property of a MappedSecretSummary.
    #: This constant has a value of "SSL_INBOUND_INSPECTION"
    TYPE_SSL_INBOUND_INSPECTION = "SSL_INBOUND_INSPECTION"

    #: A constant which can be used with the type property of a MappedSecretSummary.
    #: This constant has a value of "SSL_FORWARD_PROXY"
    TYPE_SSL_FORWARD_PROXY = "SSL_FORWARD_PROXY"

    def __init__(self, **kwargs):
        """
        Initializes a new MappedSecretSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this MappedSecretSummary.
        :type name: str

        :param source:
            The value to assign to the source property of this MappedSecretSummary.
        :type source: str

        :param type:
            The value to assign to the type property of this MappedSecretSummary.
            Allowed values for this property are: "SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this MappedSecretSummary.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'source': 'str',
            'type': 'str',
            'parent_resource_id': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'source': 'source',
            'type': 'type',
            'parent_resource_id': 'parentResourceId'
        }
        self._name = None
        self._source = None
        self._type = None
        self._parent_resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MappedSecretSummary.
        Name of the secret.


        :return: The name of this MappedSecretSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MappedSecretSummary.
        Name of the secret.


        :param name: The name of this MappedSecretSummary.
        :type: str
        """
        self._name = name

    @property
    def source(self):
        """
        **[Required]** Gets the source of this MappedSecretSummary.
        Source of the secrets, where the secrets are stored.


        :return: The source of this MappedSecretSummary.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this MappedSecretSummary.
        Source of the secrets, where the secrets are stored.


        :param source: The source of this MappedSecretSummary.
        :type: str
        """
        self._source = source

    @property
    def type(self):
        """
        **[Required]** Gets the type of this MappedSecretSummary.
        Type of the secrets mapped based on the policy.

          * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.
          * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.

        Allowed values for this property are: "SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this MappedSecretSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MappedSecretSummary.
        Type of the secrets mapped based on the policy.

          * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.
          * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.


        :param type: The type of this MappedSecretSummary.
        :type: str
        """
        allowed_values = ["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this MappedSecretSummary.
        OCID of the Network Firewall Policy this mapped secret belongs to.


        :return: The parent_resource_id of this MappedSecretSummary.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this MappedSecretSummary.
        OCID of the Network Firewall Policy this mapped secret belongs to.


        :param parent_resource_id: The parent_resource_id of this MappedSecretSummary.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
