# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateEndpointSummary(object):
    """
    To use any of the API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateEndpointSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PrivateEndpointSummary.
        :type name: str

        :param namespace:
            The value to assign to the namespace property of this PrivateEndpointSummary.
        :type namespace: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivateEndpointSummary.
        :type compartment_id: str

        :param created_by:
            The value to assign to the created_by property of this PrivateEndpointSummary.
        :type created_by: str

        :param time_created:
            The value to assign to the time_created property of this PrivateEndpointSummary.
        :type time_created: datetime

        :param time_modified:
            The value to assign to the time_modified property of this PrivateEndpointSummary.
        :type time_modified: datetime

        :param prefix:
            The value to assign to the prefix property of this PrivateEndpointSummary.
        :type prefix: str

        :param fqdns:
            The value to assign to the fqdns property of this PrivateEndpointSummary.
        :type fqdns: oci.object_storage.models.Fqdns

        :param etag:
            The value to assign to the etag property of this PrivateEndpointSummary.
        :type etag: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivateEndpointSummary.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'name': 'str',
            'namespace': 'str',
            'compartment_id': 'str',
            'created_by': 'str',
            'time_created': 'datetime',
            'time_modified': 'datetime',
            'prefix': 'str',
            'fqdns': 'Fqdns',
            'etag': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'compartment_id': 'compartmentId',
            'created_by': 'createdBy',
            'time_created': 'timeCreated',
            'time_modified': 'timeModified',
            'prefix': 'prefix',
            'fqdns': 'fqdns',
            'etag': 'etag',
            'lifecycle_state': 'lifecycleState'
        }
        self._name = None
        self._namespace = None
        self._compartment_id = None
        self._created_by = None
        self._time_created = None
        self._time_modified = None
        self._prefix = None
        self._fqdns = None
        self._etag = None
        self._lifecycle_state = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PrivateEndpointSummary.
        The name given to the Private Endpoint. Avoid entering confidential information.
        Example: my-new-pe1


        :return: The name of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PrivateEndpointSummary.
        The name given to the Private Endpoint. Avoid entering confidential information.
        Example: my-new-pe1


        :param name: The name of this PrivateEndpointSummary.
        :type: str
        """
        self._name = name

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this PrivateEndpointSummary.
        The Object Storage namespace with which the Private Endpoint is associated.


        :return: The namespace of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this PrivateEndpointSummary.
        The Object Storage namespace with which the Private Endpoint is associated.


        :param namespace: The namespace of this PrivateEndpointSummary.
        :type: str
        """
        self._namespace = namespace

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PrivateEndpointSummary.
        The compartment ID in which the Private Endpoint is authorized.


        :return: The compartment_id of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivateEndpointSummary.
        The compartment ID in which the Private Endpoint is authorized.


        :param compartment_id: The compartment_id of this PrivateEndpointSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this PrivateEndpointSummary.
        The `OCID`__ of the user who created the Private Endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The created_by of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this PrivateEndpointSummary.
        The `OCID`__ of the user who created the Private Endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param created_by: The created_by of this PrivateEndpointSummary.
        :type: str
        """
        self._created_by = created_by

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PrivateEndpointSummary.
        The date and time the Private Endpoint was created, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :return: The time_created of this PrivateEndpointSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivateEndpointSummary.
        The date and time the Private Endpoint was created, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :param time_created: The time_created of this PrivateEndpointSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_modified(self):
        """
        **[Required]** Gets the time_modified of this PrivateEndpointSummary.
        The date and time the Private Endpoint was updated, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :return: The time_modified of this PrivateEndpointSummary.
        :rtype: datetime
        """
        return self._time_modified

    @time_modified.setter
    def time_modified(self, time_modified):
        """
        Sets the time_modified of this PrivateEndpointSummary.
        The date and time the Private Endpoint was updated, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :param time_modified: The time_modified of this PrivateEndpointSummary.
        :type: datetime
        """
        self._time_modified = time_modified

    @property
    def prefix(self):
        """
        **[Required]** Gets the prefix of this PrivateEndpointSummary.
        A prefix to use for the private endpoint. The customer VCN's DNS records are
        updated with this prefix. The prefix input from the customer will be the first sub-domain in the endpointFqdn.
        Example: If the prefix chosen is \"abc\", then the endpointFqdn will be 'abc.private.objectstorage.<region>.oraclecloud.com'


        :return: The prefix of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this PrivateEndpointSummary.
        A prefix to use for the private endpoint. The customer VCN's DNS records are
        updated with this prefix. The prefix input from the customer will be the first sub-domain in the endpointFqdn.
        Example: If the prefix chosen is \"abc\", then the endpointFqdn will be 'abc.private.objectstorage.<region>.oraclecloud.com'


        :param prefix: The prefix of this PrivateEndpointSummary.
        :type: str
        """
        self._prefix = prefix

    @property
    def fqdns(self):
        """
        **[Required]** Gets the fqdns of this PrivateEndpointSummary.

        :return: The fqdns of this PrivateEndpointSummary.
        :rtype: oci.object_storage.models.Fqdns
        """
        return self._fqdns

    @fqdns.setter
    def fqdns(self, fqdns):
        """
        Sets the fqdns of this PrivateEndpointSummary.

        :param fqdns: The fqdns of this PrivateEndpointSummary.
        :type: oci.object_storage.models.Fqdns
        """
        self._fqdns = fqdns

    @property
    def etag(self):
        """
        **[Required]** Gets the etag of this PrivateEndpointSummary.
        The entity tag for the Private Endpoint.


        :return: The etag of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._etag

    @etag.setter
    def etag(self, etag):
        """
        Sets the etag of this PrivateEndpointSummary.
        The entity tag for the Private Endpoint.


        :param etag: The etag of this PrivateEndpointSummary.
        :type: str
        """
        self._etag = etag

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PrivateEndpointSummary.
        The summaries of Private Endpoints' lifecycle state.


        :return: The lifecycle_state of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivateEndpointSummary.
        The summaries of Private Endpoints' lifecycle state.


        :param lifecycle_state: The lifecycle_state of this PrivateEndpointSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
