# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddBlockVolumeToDatastoreDetails(object):
    """
    Details for the Block Volume addition to the datastore
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddBlockVolumeToDatastoreDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param block_volume_id:
            The value to assign to the block_volume_id property of this AddBlockVolumeToDatastoreDetails.
        :type block_volume_id: str

        """
        self.swagger_types = {
            'block_volume_id': 'str'
        }
        self.attribute_map = {
            'block_volume_id': 'blockVolumeId'
        }
        self._block_volume_id = None

    @property
    def block_volume_id(self):
        """
        **[Required]** Gets the block_volume_id of this AddBlockVolumeToDatastoreDetails.
        The `OCID`__ of the Block Volume to be added to the Datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The block_volume_id of this AddBlockVolumeToDatastoreDetails.
        :rtype: str
        """
        return self._block_volume_id

    @block_volume_id.setter
    def block_volume_id(self, block_volume_id):
        """
        Sets the block_volume_id of this AddBlockVolumeToDatastoreDetails.
        The `OCID`__ of the Block Volume to be added to the Datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param block_volume_id: The block_volume_id of this AddBlockVolumeToDatastoreDetails.
        :type: str
        """
        self._block_volume_id = block_volume_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
