# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OutboundClusterSummary(object):
    """
    Contains details of a Outbound cluster
    """

    #: A constant which can be used with the mode property of a OutboundClusterSummary.
    #: This constant has a value of "SEARCH_ONLY"
    MODE_SEARCH_ONLY = "SEARCH_ONLY"

    #: A constant which can be used with the mode property of a OutboundClusterSummary.
    #: This constant has a value of "REPLICATION_ONLY"
    MODE_REPLICATION_ONLY = "REPLICATION_ONLY"

    #: A constant which can be used with the mode property of a OutboundClusterSummary.
    #: This constant has a value of "SEARCH_AND_REPLICATION"
    MODE_SEARCH_AND_REPLICATION = "SEARCH_AND_REPLICATION"

    def __init__(self, **kwargs):
        """
        Initializes a new OutboundClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this OutboundClusterSummary.
        :type display_name: str

        :param ping_schedule:
            The value to assign to the ping_schedule property of this OutboundClusterSummary.
        :type ping_schedule: str

        :param is_skip_unavailable:
            The value to assign to the is_skip_unavailable property of this OutboundClusterSummary.
        :type is_skip_unavailable: bool

        :param seed_cluster_id:
            The value to assign to the seed_cluster_id property of this OutboundClusterSummary.
        :type seed_cluster_id: str

        :param mode:
            The value to assign to the mode property of this OutboundClusterSummary.
            Allowed values for this property are: "SEARCH_ONLY", "REPLICATION_ONLY", "SEARCH_AND_REPLICATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mode: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'ping_schedule': 'str',
            'is_skip_unavailable': 'bool',
            'seed_cluster_id': 'str',
            'mode': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'ping_schedule': 'pingSchedule',
            'is_skip_unavailable': 'isSkipUnavailable',
            'seed_cluster_id': 'seedClusterId',
            'mode': 'mode'
        }
        self._display_name = None
        self._ping_schedule = None
        self._is_skip_unavailable = None
        self._seed_cluster_id = None
        self._mode = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this OutboundClusterSummary.
        Name of the Outbound cluster. Avoid entering confidential information.


        :return: The display_name of this OutboundClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OutboundClusterSummary.
        Name of the Outbound cluster. Avoid entering confidential information.


        :param display_name: The display_name of this OutboundClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def ping_schedule(self):
        """
        Gets the ping_schedule of this OutboundClusterSummary.
        Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.


        :return: The ping_schedule of this OutboundClusterSummary.
        :rtype: str
        """
        return self._ping_schedule

    @ping_schedule.setter
    def ping_schedule(self, ping_schedule):
        """
        Sets the ping_schedule of this OutboundClusterSummary.
        Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.


        :param ping_schedule: The ping_schedule of this OutboundClusterSummary.
        :type: str
        """
        self._ping_schedule = ping_schedule

    @property
    def is_skip_unavailable(self):
        """
        Gets the is_skip_unavailable of this OutboundClusterSummary.
        Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable


        :return: The is_skip_unavailable of this OutboundClusterSummary.
        :rtype: bool
        """
        return self._is_skip_unavailable

    @is_skip_unavailable.setter
    def is_skip_unavailable(self, is_skip_unavailable):
        """
        Sets the is_skip_unavailable of this OutboundClusterSummary.
        Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable


        :param is_skip_unavailable: The is_skip_unavailable of this OutboundClusterSummary.
        :type: bool
        """
        self._is_skip_unavailable = is_skip_unavailable

    @property
    def seed_cluster_id(self):
        """
        **[Required]** Gets the seed_cluster_id of this OutboundClusterSummary.
        OCID of the Outbound cluster


        :return: The seed_cluster_id of this OutboundClusterSummary.
        :rtype: str
        """
        return self._seed_cluster_id

    @seed_cluster_id.setter
    def seed_cluster_id(self, seed_cluster_id):
        """
        Sets the seed_cluster_id of this OutboundClusterSummary.
        OCID of the Outbound cluster


        :param seed_cluster_id: The seed_cluster_id of this OutboundClusterSummary.
        :type: str
        """
        self._seed_cluster_id = seed_cluster_id

    @property
    def mode(self):
        """
        Gets the mode of this OutboundClusterSummary.
        Mode for the cross cluster connection

        Allowed values for this property are: "SEARCH_ONLY", "REPLICATION_ONLY", "SEARCH_AND_REPLICATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mode of this OutboundClusterSummary.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this OutboundClusterSummary.
        Mode for the cross cluster connection


        :param mode: The mode of this OutboundClusterSummary.
        :type: str
        """
        allowed_values = ["SEARCH_ONLY", "REPLICATION_ONLY", "SEARCH_AND_REPLICATION"]
        if not value_allowed_none_or_none_sentinel(mode, allowed_values):
            mode = 'UNKNOWN_ENUM_VALUE'
        self._mode = mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
