# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReverseConnectionEndpoint(object):
    """
    Reverse connection endpoint has details of endpoint in customer VCN
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReverseConnectionEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_ip:
            The value to assign to the customer_ip property of this ReverseConnectionEndpoint.
        :type customer_ip: str

        :param nat_ip:
            The value to assign to the nat_ip property of this ReverseConnectionEndpoint.
        :type nat_ip: str

        """
        self.swagger_types = {
            'customer_ip': 'str',
            'nat_ip': 'str'
        }
        self.attribute_map = {
            'customer_ip': 'customerIp',
            'nat_ip': 'natIp'
        }
        self._customer_ip = None
        self._nat_ip = None

    @property
    def customer_ip(self):
        """
        **[Required]** Gets the customer_ip of this ReverseConnectionEndpoint.
        The IP addresses of the endpoint in customer VCN


        :return: The customer_ip of this ReverseConnectionEndpoint.
        :rtype: str
        """
        return self._customer_ip

    @customer_ip.setter
    def customer_ip(self, customer_ip):
        """
        Sets the customer_ip of this ReverseConnectionEndpoint.
        The IP addresses of the endpoint in customer VCN


        :param customer_ip: The customer_ip of this ReverseConnectionEndpoint.
        :type: str
        """
        self._customer_ip = customer_ip

    @property
    def nat_ip(self):
        """
        **[Required]** Gets the nat_ip of this ReverseConnectionEndpoint.
        The NAT IP addresses of the endpoint in service VCN


        :return: The nat_ip of this ReverseConnectionEndpoint.
        :rtype: str
        """
        return self._nat_ip

    @nat_ip.setter
    def nat_ip(self, nat_ip):
        """
        Sets the nat_ip of this ReverseConnectionEndpoint.
        The NAT IP addresses of the endpoint in service VCN


        :param nat_ip: The nat_ip of this ReverseConnectionEndpoint.
        :type: str
        """
        self._nat_ip = nat_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
