# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SummarizeExadataInsightResourceUtilizationInsightAggregation(object):
    """
    Insights response containing utilization values for exadata systems.
    """

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "CPU"
    EXADATA_RESOURCE_METRIC_CPU = "CPU"

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "STORAGE"
    EXADATA_RESOURCE_METRIC_STORAGE = "STORAGE"

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "IO"
    EXADATA_RESOURCE_METRIC_IO = "IO"

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "MEMORY"
    EXADATA_RESOURCE_METRIC_MEMORY = "MEMORY"

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "IOPS"
    EXADATA_RESOURCE_METRIC_IOPS = "IOPS"

    #: A constant which can be used with the exadata_resource_metric property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "THROUGHPUT"
    EXADATA_RESOURCE_METRIC_THROUGHPUT = "THROUGHPUT"

    #: A constant which can be used with the exadata_resource_type property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "DATABASE"
    EXADATA_RESOURCE_TYPE_DATABASE = "DATABASE"

    #: A constant which can be used with the exadata_resource_type property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "HOST"
    EXADATA_RESOURCE_TYPE_HOST = "HOST"

    #: A constant which can be used with the exadata_resource_type property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "STORAGE_SERVER"
    EXADATA_RESOURCE_TYPE_STORAGE_SERVER = "STORAGE_SERVER"

    #: A constant which can be used with the exadata_resource_type property of a SummarizeExadataInsightResourceUtilizationInsightAggregation.
    #: This constant has a value of "DISKGROUP"
    EXADATA_RESOURCE_TYPE_DISKGROUP = "DISKGROUP"

    def __init__(self, **kwargs):
        """
        Initializes a new SummarizeExadataInsightResourceUtilizationInsightAggregation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_interval_start:
            The value to assign to the time_interval_start property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type time_interval_start: datetime

        :param time_interval_end:
            The value to assign to the time_interval_end property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type time_interval_end: datetime

        :param high_utilization_threshold:
            The value to assign to the high_utilization_threshold property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type high_utilization_threshold: int

        :param low_utilization_threshold:
            The value to assign to the low_utilization_threshold property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type low_utilization_threshold: int

        :param exadata_resource_metric:
            The value to assign to the exadata_resource_metric property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
            Allowed values for this property are: "CPU", "STORAGE", "IO", "MEMORY", "IOPS", "THROUGHPUT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type exadata_resource_metric: str

        :param exadata_resource_type:
            The value to assign to the exadata_resource_type property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
            Allowed values for this property are: "DATABASE", "HOST", "STORAGE_SERVER", "DISKGROUP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type exadata_resource_type: str

        :param utilization:
            The value to assign to the utilization property of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type utilization: list[oci.opsi.models.ExadataInsightResourceInsightUtilizationItem]

        """
        self.swagger_types = {
            'time_interval_start': 'datetime',
            'time_interval_end': 'datetime',
            'high_utilization_threshold': 'int',
            'low_utilization_threshold': 'int',
            'exadata_resource_metric': 'str',
            'exadata_resource_type': 'str',
            'utilization': 'list[ExadataInsightResourceInsightUtilizationItem]'
        }
        self.attribute_map = {
            'time_interval_start': 'timeIntervalStart',
            'time_interval_end': 'timeIntervalEnd',
            'high_utilization_threshold': 'highUtilizationThreshold',
            'low_utilization_threshold': 'lowUtilizationThreshold',
            'exadata_resource_metric': 'exadataResourceMetric',
            'exadata_resource_type': 'exadataResourceType',
            'utilization': 'utilization'
        }
        self._time_interval_start = None
        self._time_interval_end = None
        self._high_utilization_threshold = None
        self._low_utilization_threshold = None
        self._exadata_resource_metric = None
        self._exadata_resource_type = None
        self._utilization = None

    @property
    def time_interval_start(self):
        """
        **[Required]** Gets the time_interval_start of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        The start timestamp that was passed into the request.


        :return: The time_interval_start of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: datetime
        """
        return self._time_interval_start

    @time_interval_start.setter
    def time_interval_start(self, time_interval_start):
        """
        Sets the time_interval_start of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        The start timestamp that was passed into the request.


        :param time_interval_start: The time_interval_start of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: datetime
        """
        self._time_interval_start = time_interval_start

    @property
    def time_interval_end(self):
        """
        **[Required]** Gets the time_interval_end of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        The end timestamp that was passed into the request.


        :return: The time_interval_end of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: datetime
        """
        return self._time_interval_end

    @time_interval_end.setter
    def time_interval_end(self, time_interval_end):
        """
        Sets the time_interval_end of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        The end timestamp that was passed into the request.


        :param time_interval_end: The time_interval_end of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: datetime
        """
        self._time_interval_end = time_interval_end

    @property
    def high_utilization_threshold(self):
        """
        **[Required]** Gets the high_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Percent value in which a resource metric is considered highly utilized.


        :return: The high_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: int
        """
        return self._high_utilization_threshold

    @high_utilization_threshold.setter
    def high_utilization_threshold(self, high_utilization_threshold):
        """
        Sets the high_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Percent value in which a resource metric is considered highly utilized.


        :param high_utilization_threshold: The high_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: int
        """
        self._high_utilization_threshold = high_utilization_threshold

    @property
    def low_utilization_threshold(self):
        """
        **[Required]** Gets the low_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Percent value in which a resource metric is considered lowly utilized.


        :return: The low_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: int
        """
        return self._low_utilization_threshold

    @low_utilization_threshold.setter
    def low_utilization_threshold(self, low_utilization_threshold):
        """
        Sets the low_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Percent value in which a resource metric is considered lowly utilized.


        :param low_utilization_threshold: The low_utilization_threshold of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: int
        """
        self._low_utilization_threshold = low_utilization_threshold

    @property
    def exadata_resource_metric(self):
        """
        **[Required]** Gets the exadata_resource_metric of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Defines the type of exadata resource metric (example: CPU, STORAGE)

        Allowed values for this property are: "CPU", "STORAGE", "IO", "MEMORY", "IOPS", "THROUGHPUT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The exadata_resource_metric of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: str
        """
        return self._exadata_resource_metric

    @exadata_resource_metric.setter
    def exadata_resource_metric(self, exadata_resource_metric):
        """
        Sets the exadata_resource_metric of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Defines the type of exadata resource metric (example: CPU, STORAGE)


        :param exadata_resource_metric: The exadata_resource_metric of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: str
        """
        allowed_values = ["CPU", "STORAGE", "IO", "MEMORY", "IOPS", "THROUGHPUT"]
        if not value_allowed_none_or_none_sentinel(exadata_resource_metric, allowed_values):
            exadata_resource_metric = 'UNKNOWN_ENUM_VALUE'
        self._exadata_resource_metric = exadata_resource_metric

    @property
    def exadata_resource_type(self):
        """
        **[Required]** Gets the exadata_resource_type of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Defines the resource type for an exadata  (example: DATABASE, STORAGE_SERVER, HOST, DISKGROUP)

        Allowed values for this property are: "DATABASE", "HOST", "STORAGE_SERVER", "DISKGROUP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The exadata_resource_type of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: str
        """
        return self._exadata_resource_type

    @exadata_resource_type.setter
    def exadata_resource_type(self, exadata_resource_type):
        """
        Sets the exadata_resource_type of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Defines the resource type for an exadata  (example: DATABASE, STORAGE_SERVER, HOST, DISKGROUP)


        :param exadata_resource_type: The exadata_resource_type of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: str
        """
        allowed_values = ["DATABASE", "HOST", "STORAGE_SERVER", "DISKGROUP"]
        if not value_allowed_none_or_none_sentinel(exadata_resource_type, allowed_values):
            exadata_resource_type = 'UNKNOWN_ENUM_VALUE'
        self._exadata_resource_type = exadata_resource_type

    @property
    def utilization(self):
        """
        **[Required]** Gets the utilization of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Collection of Exadata system utilization


        :return: The utilization of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :rtype: list[oci.opsi.models.ExadataInsightResourceInsightUtilizationItem]
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        Collection of Exadata system utilization


        :param utilization: The utilization of this SummarizeExadataInsightResourceUtilizationInsightAggregation.
        :type: list[oci.opsi.models.ExadataInsightResourceInsightUtilizationItem]
        """
        self._utilization = utilization

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
