# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031

from .adw_admin_password_details import AdwAdminPasswordDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlainTextPasswordDetails(AdwAdminPasswordDetails):
    """
    Details for the PLAIN_TEXT ADW Admin password.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PlainTextPasswordDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.resource_analytics.models.PlainTextPasswordDetails.password_type` attribute
        of this class is ``PLAIN_TEXT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param password_type:
            The value to assign to the password_type property of this PlainTextPasswordDetails.
            Allowed values for this property are: "PLAIN_TEXT", "VAULT_SECRET"
        :type password_type: str

        :param password:
            The value to assign to the password property of this PlainTextPasswordDetails.
        :type password: str

        """
        self.swagger_types = {
            'password_type': 'str',
            'password': 'str'
        }
        self.attribute_map = {
            'password_type': 'passwordType',
            'password': 'password'
        }
        self._password_type = None
        self._password = None
        self._password_type = 'PLAIN_TEXT'

    @property
    def password(self):
        """
        **[Required]** Gets the password of this PlainTextPasswordDetails.
        Password for the ADW to be created in User Tenancy. The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (\") or the username \"admin\", regardless of casing.


        :return: The password of this PlainTextPasswordDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this PlainTextPasswordDetails.
        Password for the ADW to be created in User Tenancy. The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (\") or the username \"admin\", regardless of casing.


        :param password: The password of this PlainTextPasswordDetails.
        :type: str
        """
        self._password = password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
