# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TenancyAttachmentSummary(object):
    """
    Summary information about a TenancyAttachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TenancyAttachmentSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this TenancyAttachmentSummary.
        :type id: str

        :param description:
            The value to assign to the description property of this TenancyAttachmentSummary.
        :type description: str

        :param resource_analytics_instance_id:
            The value to assign to the resource_analytics_instance_id property of this TenancyAttachmentSummary.
        :type resource_analytics_instance_id: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this TenancyAttachmentSummary.
        :type tenancy_id: str

        :param is_reporting_tenancy:
            The value to assign to the is_reporting_tenancy property of this TenancyAttachmentSummary.
        :type is_reporting_tenancy: bool

        :param time_created:
            The value to assign to the time_created property of this TenancyAttachmentSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this TenancyAttachmentSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TenancyAttachmentSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this TenancyAttachmentSummary.
        :type lifecycle_details: str

        :param system_tags:
            The value to assign to the system_tags property of this TenancyAttachmentSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'resource_analytics_instance_id': 'str',
            'tenancy_id': 'str',
            'is_reporting_tenancy': 'bool',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'resource_analytics_instance_id': 'resourceAnalyticsInstanceId',
            'tenancy_id': 'tenancyId',
            'is_reporting_tenancy': 'isReportingTenancy',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._description = None
        self._resource_analytics_instance_id = None
        self._tenancy_id = None
        self._is_reporting_tenancy = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this TenancyAttachmentSummary.
        The `OCID`__ of the TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TenancyAttachmentSummary.
        The `OCID`__ of the TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this TenancyAttachmentSummary.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this TenancyAttachmentSummary.
        A description of the tenancy.


        :return: The description of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this TenancyAttachmentSummary.
        A description of the tenancy.


        :param description: The description of this TenancyAttachmentSummary.
        :type: str
        """
        self._description = description

    @property
    def resource_analytics_instance_id(self):
        """
        **[Required]** Gets the resource_analytics_instance_id of this TenancyAttachmentSummary.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_analytics_instance_id of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._resource_analytics_instance_id

    @resource_analytics_instance_id.setter
    def resource_analytics_instance_id(self, resource_analytics_instance_id):
        """
        Sets the resource_analytics_instance_id of this TenancyAttachmentSummary.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_analytics_instance_id: The resource_analytics_instance_id of this TenancyAttachmentSummary.
        :type: str
        """
        self._resource_analytics_instance_id = resource_analytics_instance_id

    @property
    def tenancy_id(self):
        """
        **[Required]** Gets the tenancy_id of this TenancyAttachmentSummary.
        The `OCID`__ of the tenancy associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The tenancy_id of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this TenancyAttachmentSummary.
        The `OCID`__ of the tenancy associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param tenancy_id: The tenancy_id of this TenancyAttachmentSummary.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def is_reporting_tenancy(self):
        """
        **[Required]** Gets the is_reporting_tenancy of this TenancyAttachmentSummary.
        Whether the tenancy is the tenancy used when creating Resource Analytics Instance.


        :return: The is_reporting_tenancy of this TenancyAttachmentSummary.
        :rtype: bool
        """
        return self._is_reporting_tenancy

    @is_reporting_tenancy.setter
    def is_reporting_tenancy(self, is_reporting_tenancy):
        """
        Sets the is_reporting_tenancy of this TenancyAttachmentSummary.
        Whether the tenancy is the tenancy used when creating Resource Analytics Instance.


        :param is_reporting_tenancy: The is_reporting_tenancy of this TenancyAttachmentSummary.
        :type: bool
        """
        self._is_reporting_tenancy = is_reporting_tenancy

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this TenancyAttachmentSummary.
        The date and time the TenancyAttachment was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this TenancyAttachmentSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this TenancyAttachmentSummary.
        The date and time the TenancyAttachment was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this TenancyAttachmentSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this TenancyAttachmentSummary.
        The date and time the TenancyAttachment was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this TenancyAttachmentSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this TenancyAttachmentSummary.
        The date and time the TenancyAttachment was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this TenancyAttachmentSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this TenancyAttachmentSummary.
        The current state of the TenancyAttachment.


        :return: The lifecycle_state of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this TenancyAttachmentSummary.
        The current state of the TenancyAttachment.


        :param lifecycle_state: The lifecycle_state of this TenancyAttachmentSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this TenancyAttachmentSummary.
        A message that describes the current state of the TenancyAttachment in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this TenancyAttachmentSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this TenancyAttachmentSummary.
        A message that describes the current state of the TenancyAttachment in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this TenancyAttachmentSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def system_tags(self):
        """
        Gets the system_tags of this TenancyAttachmentSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this TenancyAttachmentSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this TenancyAttachmentSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this TenancyAttachmentSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
