# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FolderToScan(object):
    """
    Folder selected for scanning
    """

    #: A constant which can be used with the operatingsystem property of a FolderToScan.
    #: This constant has a value of "LINUX"
    OPERATINGSYSTEM_LINUX = "LINUX"

    #: A constant which can be used with the operatingsystem property of a FolderToScan.
    #: This constant has a value of "WINDOWS"
    OPERATINGSYSTEM_WINDOWS = "WINDOWS"

    def __init__(self, **kwargs):
        """
        Initializes a new FolderToScan object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operatingsystem:
            The value to assign to the operatingsystem property of this FolderToScan.
            Allowed values for this property are: "LINUX", "WINDOWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operatingsystem: str

        :param folder:
            The value to assign to the folder property of this FolderToScan.
        :type folder: str

        """
        self.swagger_types = {
            'operatingsystem': 'str',
            'folder': 'str'
        }
        self.attribute_map = {
            'operatingsystem': 'operatingsystem',
            'folder': 'folder'
        }
        self._operatingsystem = None
        self._folder = None

    @property
    def operatingsystem(self):
        """
        **[Required]** Gets the operatingsystem of this FolderToScan.
        Operating system type

        Allowed values for this property are: "LINUX", "WINDOWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operatingsystem of this FolderToScan.
        :rtype: str
        """
        return self._operatingsystem

    @operatingsystem.setter
    def operatingsystem(self, operatingsystem):
        """
        Sets the operatingsystem of this FolderToScan.
        Operating system type


        :param operatingsystem: The operatingsystem of this FolderToScan.
        :type: str
        """
        allowed_values = ["LINUX", "WINDOWS"]
        if not value_allowed_none_or_none_sentinel(operatingsystem, allowed_values):
            operatingsystem = 'UNKNOWN_ENUM_VALUE'
        self._operatingsystem = operatingsystem

    @property
    def folder(self):
        """
        **[Required]** Gets the folder of this FolderToScan.
        Folder to be scanned in the corresponding operating system


        :return: The folder of this FolderToScan.
        :rtype: str
        """
        return self._folder

    @folder.setter
    def folder(self, folder):
        """
        Sets the folder of this FolderToScan.
        Folder to be scanned in the corresponding operating system


        :param folder: The folder of this FolderToScan.
        :type: str
        """
        self._folder = folder

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
