# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchDetectHealthEntityDetails(object):
    """
    The documents details for health entities detect call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchDetectHealthEntityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param alias:
            The value to assign to the alias property of this BatchDetectHealthEntityDetails.
        :type alias: str

        :param endpoint_id:
            The value to assign to the endpoint_id property of this BatchDetectHealthEntityDetails.
        :type endpoint_id: str

        :param documents:
            The value to assign to the documents property of this BatchDetectHealthEntityDetails.
        :type documents: list[oci.ai_language.models.TextDocument]

        :param link_ontologies:
            The value to assign to the link_ontologies property of this BatchDetectHealthEntityDetails.
        :type link_ontologies: list[str]

        :param is_detect_assertions:
            The value to assign to the is_detect_assertions property of this BatchDetectHealthEntityDetails.
        :type is_detect_assertions: bool

        :param is_detect_relationships:
            The value to assign to the is_detect_relationships property of this BatchDetectHealthEntityDetails.
        :type is_detect_relationships: bool

        :param profile:
            The value to assign to the profile property of this BatchDetectHealthEntityDetails.
        :type profile: oci.ai_language.models.Profile

        """
        self.swagger_types = {
            'alias': 'str',
            'endpoint_id': 'str',
            'documents': 'list[TextDocument]',
            'link_ontologies': 'list[str]',
            'is_detect_assertions': 'bool',
            'is_detect_relationships': 'bool',
            'profile': 'Profile'
        }
        self.attribute_map = {
            'alias': 'alias',
            'endpoint_id': 'endpointId',
            'documents': 'documents',
            'link_ontologies': 'linkOntologies',
            'is_detect_assertions': 'isDetectAssertions',
            'is_detect_relationships': 'isDetectRelationships',
            'profile': 'profile'
        }
        self._alias = None
        self._endpoint_id = None
        self._documents = None
        self._link_ontologies = None
        self._is_detect_assertions = None
        self._is_detect_relationships = None
        self._profile = None

    @property
    def alias(self):
        """
        Gets the alias of this BatchDetectHealthEntityDetails.
        Unique name across user tenancy in a region to identify an endpoint to be used for inferencing.


        :return: The alias of this BatchDetectHealthEntityDetails.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this BatchDetectHealthEntityDetails.
        Unique name across user tenancy in a region to identify an endpoint to be used for inferencing.


        :param alias: The alias of this BatchDetectHealthEntityDetails.
        :type: str
        """
        self._alias = alias

    @property
    def endpoint_id(self):
        """
        **[Required]** Gets the endpoint_id of this BatchDetectHealthEntityDetails.
        The endpoint which have to be used for inferencing.


        :return: The endpoint_id of this BatchDetectHealthEntityDetails.
        :rtype: str
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this BatchDetectHealthEntityDetails.
        The endpoint which have to be used for inferencing.


        :param endpoint_id: The endpoint_id of this BatchDetectHealthEntityDetails.
        :type: str
        """
        self._endpoint_id = endpoint_id

    @property
    def documents(self):
        """
        **[Required]** Gets the documents of this BatchDetectHealthEntityDetails.
        List of Documents for detect health entities.


        :return: The documents of this BatchDetectHealthEntityDetails.
        :rtype: list[oci.ai_language.models.TextDocument]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this BatchDetectHealthEntityDetails.
        List of Documents for detect health entities.


        :param documents: The documents of this BatchDetectHealthEntityDetails.
        :type: list[oci.ai_language.models.TextDocument]
        """
        self._documents = documents

    @property
    def link_ontologies(self):
        """
        Gets the link_ontologies of this BatchDetectHealthEntityDetails.
        List of NLP health ontologies to be linked


        :return: The link_ontologies of this BatchDetectHealthEntityDetails.
        :rtype: list[str]
        """
        return self._link_ontologies

    @link_ontologies.setter
    def link_ontologies(self, link_ontologies):
        """
        Sets the link_ontologies of this BatchDetectHealthEntityDetails.
        List of NLP health ontologies to be linked


        :param link_ontologies: The link_ontologies of this BatchDetectHealthEntityDetails.
        :type: list[str]
        """
        self._link_ontologies = link_ontologies

    @property
    def is_detect_assertions(self):
        """
        Gets the is_detect_assertions of this BatchDetectHealthEntityDetails.
        is assertion on input text required. default value true.


        :return: The is_detect_assertions of this BatchDetectHealthEntityDetails.
        :rtype: bool
        """
        return self._is_detect_assertions

    @is_detect_assertions.setter
    def is_detect_assertions(self, is_detect_assertions):
        """
        Sets the is_detect_assertions of this BatchDetectHealthEntityDetails.
        is assertion on input text required. default value true.


        :param is_detect_assertions: The is_detect_assertions of this BatchDetectHealthEntityDetails.
        :type: bool
        """
        self._is_detect_assertions = is_detect_assertions

    @property
    def is_detect_relationships(self):
        """
        Gets the is_detect_relationships of this BatchDetectHealthEntityDetails.
        is relationship on input text required. default value true.


        :return: The is_detect_relationships of this BatchDetectHealthEntityDetails.
        :rtype: bool
        """
        return self._is_detect_relationships

    @is_detect_relationships.setter
    def is_detect_relationships(self, is_detect_relationships):
        """
        Sets the is_detect_relationships of this BatchDetectHealthEntityDetails.
        is relationship on input text required. default value true.


        :param is_detect_relationships: The is_detect_relationships of this BatchDetectHealthEntityDetails.
        :type: bool
        """
        self._is_detect_relationships = is_detect_relationships

    @property
    def profile(self):
        """
        Gets the profile of this BatchDetectHealthEntityDetails.

        :return: The profile of this BatchDetectHealthEntityDetails.
        :rtype: oci.ai_language.models.Profile
        """
        return self._profile

    @profile.setter
    def profile(self, profile):
        """
        Sets the profile of this BatchDetectHealthEntityDetails.

        :param profile: The profile of this BatchDetectHealthEntityDetails.
        :type: oci.ai_language.models.Profile
        """
        self._profile = profile

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
