# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PiiEntity(object):
    """
    PII entity object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PiiEntity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PiiEntity.
        :type id: str

        :param offset:
            The value to assign to the offset property of this PiiEntity.
        :type offset: int

        :param length:
            The value to assign to the length property of this PiiEntity.
        :type length: int

        :param text:
            The value to assign to the text property of this PiiEntity.
        :type text: str

        :param relexify_text:
            The value to assign to the relexify_text property of this PiiEntity.
        :type relexify_text: str

        :param type:
            The value to assign to the type property of this PiiEntity.
        :type type: str

        :param score:
            The value to assign to the score property of this PiiEntity.
        :type score: float

        """
        self.swagger_types = {
            'id': 'str',
            'offset': 'int',
            'length': 'int',
            'text': 'str',
            'relexify_text': 'str',
            'type': 'str',
            'score': 'float'
        }
        self.attribute_map = {
            'id': 'id',
            'offset': 'offset',
            'length': 'length',
            'text': 'text',
            'relexify_text': 'relexifyText',
            'type': 'type',
            'score': 'score'
        }
        self._id = None
        self._offset = None
        self._length = None
        self._text = None
        self._relexify_text = None
        self._type = None
        self._score = None

    @property
    def id(self):
        """
        Gets the id of this PiiEntity.
        Unique id of the entity.


        :return: The id of this PiiEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PiiEntity.
        Unique id of the entity.


        :param id: The id of this PiiEntity.
        :type: str
        """
        self._id = id

    @property
    def offset(self):
        """
        **[Required]** Gets the offset of this PiiEntity.
        The number of Unicode code points preceding this entity in the submitted text.


        :return: The offset of this PiiEntity.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this PiiEntity.
        The number of Unicode code points preceding this entity in the submitted text.


        :param offset: The offset of this PiiEntity.
        :type: int
        """
        self._offset = offset

    @property
    def length(self):
        """
        **[Required]** Gets the length of this PiiEntity.
        Length of PII entity text.


        :return: The length of this PiiEntity.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this PiiEntity.
        Length of PII entity text.


        :param length: The length of this PiiEntity.
        :type: int
        """
        self._length = length

    @property
    def text(self):
        """
        **[Required]** Gets the text of this PiiEntity.
        Entity text like name of person, Organization and so on.


        :return: The text of this PiiEntity.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this PiiEntity.
        Entity text like name of person, Organization and so on.


        :param text: The text of this PiiEntity.
        :type: str
        """
        self._text = text

    @property
    def relexify_text(self):
        """
        Gets the relexify_text of this PiiEntity.
        Redacted entity text


        :return: The relexify_text of this PiiEntity.
        :rtype: str
        """
        return self._relexify_text

    @relexify_text.setter
    def relexify_text(self, relexify_text):
        """
        Sets the relexify_text of this PiiEntity.
        Redacted entity text


        :param relexify_text: The relexify_text of this PiiEntity.
        :type: str
        """
        self._relexify_text = relexify_text

    @property
    def type(self):
        """
        **[Required]** Gets the type of this PiiEntity.
        Entity type supported
        PERSON
        ADDRESS
        AGE
        DATE_TIME
        SSN_OR_TAXPAYER
        EMAIL
        PASSPORT_NUMBER_US
        TELEPHONE_NUMBER
        DRIVER_ID_US
        BANK_ACCOUNT_NUMBER
        BANK_SWIFT
        BANK_ROUTING
        CREDIT_DEBIT_NUMBER
        IP_ADDRESS
        MAC_ADDRESS
        COOKIE
        XSRF_TOKEN
        AUTH_BASIC
        AUTH_BEARER
        JSON_WEB_TOKEN
        PRIVATE_KEY
        PUBLIC_KEY
        OCI_OCID_USER
        OCI_OCID_TENANCY
        OCI_SMTP_USERNAME
        OCI_OCID_REFERENCE
        OCI_FINGERPRINT
        OCI_CREDENTIAL
        OCI_PRE_AUTH_REQUEST
        OCI_STORAGE_SIGNED_URL
        OCI_CUSTOMER_SECRET_KEY
        OCI_ACCESS_KEy
        MEDICAL_RECORD_NUMBER
        HEALTH_PLAN_ID
        URL
        CERTIFICATE_NUMBER
        FIN
        GUIDs
        VEHICLE_LICENSE_PLATE_US
        VEHICLE_IDENTIFIER_US


        :return: The type of this PiiEntity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PiiEntity.
        Entity type supported
        PERSON
        ADDRESS
        AGE
        DATE_TIME
        SSN_OR_TAXPAYER
        EMAIL
        PASSPORT_NUMBER_US
        TELEPHONE_NUMBER
        DRIVER_ID_US
        BANK_ACCOUNT_NUMBER
        BANK_SWIFT
        BANK_ROUTING
        CREDIT_DEBIT_NUMBER
        IP_ADDRESS
        MAC_ADDRESS
        COOKIE
        XSRF_TOKEN
        AUTH_BASIC
        AUTH_BEARER
        JSON_WEB_TOKEN
        PRIVATE_KEY
        PUBLIC_KEY
        OCI_OCID_USER
        OCI_OCID_TENANCY
        OCI_SMTP_USERNAME
        OCI_OCID_REFERENCE
        OCI_FINGERPRINT
        OCI_CREDENTIAL
        OCI_PRE_AUTH_REQUEST
        OCI_STORAGE_SIGNED_URL
        OCI_CUSTOMER_SECRET_KEY
        OCI_ACCESS_KEy
        MEDICAL_RECORD_NUMBER
        HEALTH_PLAN_ID
        URL
        CERTIFICATE_NUMBER
        FIN
        GUIDs
        VEHICLE_LICENSE_PLATE_US
        VEHICLE_IDENTIFIER_US


        :param type: The type of this PiiEntity.
        :type: str
        """
        self._type = type

    @property
    def score(self):
        """
        **[Required]** Gets the score of this PiiEntity.
        Score or confidence for detected PII entity.


        :return: The score of this PiiEntity.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this PiiEntity.
        Score or confidence for detected PII entity.


        :param score: The score of this PiiEntity.
        :type: float
        """
        self._score = score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
