# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivilegedApiControl(object):
    """
    A PrivilegedApiControl is a kind of Policy definition which provides details about which operations needs to be secure; who can approve a privilegedApiRequest requesting for a particular operation, whether the operations needs to be approved by customer or is it preApproved.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiControl.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new PrivilegedApiControl object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivilegedApiControl.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PrivilegedApiControl.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivilegedApiControl.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this PrivilegedApiControl.
        :type description: str

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this PrivilegedApiControl.
        :type notification_topic_id: str

        :param approver_group_id_list:
            The value to assign to the approver_group_id_list property of this PrivilegedApiControl.
        :type approver_group_id_list: list[str]

        :param resource_type:
            The value to assign to the resource_type property of this PrivilegedApiControl.
        :type resource_type: str

        :param resources:
            The value to assign to the resources property of this PrivilegedApiControl.
        :type resources: list[str]

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this PrivilegedApiControl.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]

        :param number_of_approvers:
            The value to assign to the number_of_approvers property of this PrivilegedApiControl.
        :type number_of_approvers: int

        :param time_created:
            The value to assign to the time_created property of this PrivilegedApiControl.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivilegedApiControl.
        :type time_updated: datetime

        :param time_deleted:
            The value to assign to the time_deleted property of this PrivilegedApiControl.
        :type time_deleted: datetime

        :param state:
            The value to assign to the state property of this PrivilegedApiControl.
        :type state: str

        :param state_details:
            The value to assign to the state_details property of this PrivilegedApiControl.
        :type state_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivilegedApiControl.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PrivilegedApiControl.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivilegedApiControl.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivilegedApiControl.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PrivilegedApiControl.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'notification_topic_id': 'str',
            'approver_group_id_list': 'list[str]',
            'resource_type': 'str',
            'resources': 'list[str]',
            'privileged_operation_list': 'list[PrivilegedApiDetails]',
            'number_of_approvers': 'int',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_deleted': 'datetime',
            'state': 'str',
            'state_details': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'notification_topic_id': 'notificationTopicId',
            'approver_group_id_list': 'approverGroupIdList',
            'resource_type': 'resourceType',
            'resources': 'resources',
            'privileged_operation_list': 'privilegedOperationList',
            'number_of_approvers': 'numberOfApprovers',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_deleted': 'timeDeleted',
            'state': 'state',
            'state_details': 'stateDetails',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._description = None
        self._notification_topic_id = None
        self._approver_group_id_list = None
        self._resource_type = None
        self._resources = None
        self._privileged_operation_list = None
        self._number_of_approvers = None
        self._time_created = None
        self._time_updated = None
        self._time_deleted = None
        self._state = None
        self._state_details = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivilegedApiControl.
        The `OCID`__ of the PrivilegedApiControl.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this PrivilegedApiControl.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivilegedApiControl.
        The `OCID`__ of the PrivilegedApiControl.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this PrivilegedApiControl.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PrivilegedApiControl.
        Name of the privilegedApi control. The name must be unique.


        :return: The display_name of this PrivilegedApiControl.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivilegedApiControl.
        Name of the privilegedApi control. The name must be unique.


        :param display_name: The display_name of this PrivilegedApiControl.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PrivilegedApiControl.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PrivilegedApiControl.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivilegedApiControl.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PrivilegedApiControl.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this PrivilegedApiControl.
        Description of privilegedApi control.


        :return: The description of this PrivilegedApiControl.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PrivilegedApiControl.
        Description of privilegedApi control.


        :param description: The description of this PrivilegedApiControl.
        :type: str
        """
        self._description = description

    @property
    def notification_topic_id(self):
        """
        Gets the notification_topic_id of this PrivilegedApiControl.
        The OCID of the OCI Notification topic to publish messages related to this Privileged Api Control.


        :return: The notification_topic_id of this PrivilegedApiControl.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this PrivilegedApiControl.
        The OCID of the OCI Notification topic to publish messages related to this Privileged Api Control.


        :param notification_topic_id: The notification_topic_id of this PrivilegedApiControl.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def approver_group_id_list(self):
        """
        Gets the approver_group_id_list of this PrivilegedApiControl.
        List of IAM user group ids who can approve an privilegedApi request associated with a target resource under the governance of this operator control.


        :return: The approver_group_id_list of this PrivilegedApiControl.
        :rtype: list[str]
        """
        return self._approver_group_id_list

    @approver_group_id_list.setter
    def approver_group_id_list(self, approver_group_id_list):
        """
        Sets the approver_group_id_list of this PrivilegedApiControl.
        List of IAM user group ids who can approve an privilegedApi request associated with a target resource under the governance of this operator control.


        :param approver_group_id_list: The approver_group_id_list of this PrivilegedApiControl.
        :type: list[str]
        """
        self._approver_group_id_list = approver_group_id_list

    @property
    def resource_type(self):
        """
        Gets the resource_type of this PrivilegedApiControl.
        resourceType for which the PrivilegedApiControl is applicable


        :return: The resource_type of this PrivilegedApiControl.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this PrivilegedApiControl.
        resourceType for which the PrivilegedApiControl is applicable


        :param resource_type: The resource_type of this PrivilegedApiControl.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def resources(self):
        """
        Gets the resources of this PrivilegedApiControl.
        contains Resource details


        :return: The resources of this PrivilegedApiControl.
        :rtype: list[str]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this PrivilegedApiControl.
        contains Resource details


        :param resources: The resources of this PrivilegedApiControl.
        :type: list[str]
        """
        self._resources = resources

    @property
    def privileged_operation_list(self):
        """
        Gets the privileged_operation_list of this PrivilegedApiControl.
        List of privileged operations/apis. These operations/apis will be treaated as secured, once enabled by the Privileged API Managment for a resource. Any of these operations, if needs to be executed, needs to be raised as a PrivilegedApi Request which needs to be approved by customers or it can be pre-approved.


        :return: The privileged_operation_list of this PrivilegedApiControl.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this PrivilegedApiControl.
        List of privileged operations/apis. These operations/apis will be treaated as secured, once enabled by the Privileged API Managment for a resource. Any of these operations, if needs to be executed, needs to be raised as a PrivilegedApi Request which needs to be approved by customers or it can be pre-approved.


        :param privileged_operation_list: The privileged_operation_list of this PrivilegedApiControl.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def number_of_approvers(self):
        """
        Gets the number_of_approvers of this PrivilegedApiControl.
        Number of approvers required to approve an privilegedApi request.


        :return: The number_of_approvers of this PrivilegedApiControl.
        :rtype: int
        """
        return self._number_of_approvers

    @number_of_approvers.setter
    def number_of_approvers(self, number_of_approvers):
        """
        Sets the number_of_approvers of this PrivilegedApiControl.
        Number of approvers required to approve an privilegedApi request.


        :param number_of_approvers: The number_of_approvers of this PrivilegedApiControl.
        :type: int
        """
        self._number_of_approvers = number_of_approvers

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PrivilegedApiControl.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PrivilegedApiControl.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this PrivilegedApiControl.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this PrivilegedApiControl.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_deleted(self):
        """
        Gets the time_deleted of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_deleted of this PrivilegedApiControl.
        :rtype: datetime
        """
        return self._time_deleted

    @time_deleted.setter
    def time_deleted(self, time_deleted):
        """
        Sets the time_deleted of this PrivilegedApiControl.
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_deleted: The time_deleted of this PrivilegedApiControl.
        :type: datetime
        """
        self._time_deleted = time_deleted

    @property
    def state(self):
        """
        **[Required]** Gets the state of this PrivilegedApiControl.
        The current state of the PrivilegedApiControl.


        :return: The state of this PrivilegedApiControl.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this PrivilegedApiControl.
        The current state of the PrivilegedApiControl.


        :param state: The state of this PrivilegedApiControl.
        :type: str
        """
        self._state = state

    @property
    def state_details(self):
        """
        Gets the state_details of this PrivilegedApiControl.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The state_details of this PrivilegedApiControl.
        :rtype: str
        """
        return self._state_details

    @state_details.setter
    def state_details(self, state_details):
        """
        Sets the state_details of this PrivilegedApiControl.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param state_details: The state_details of this PrivilegedApiControl.
        :type: str
        """
        self._state_details = state_details

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PrivilegedApiControl.
        The current state of the PrivilegedApiControl.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this PrivilegedApiControl.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivilegedApiControl.
        The current state of the PrivilegedApiControl.


        :param lifecycle_state: The lifecycle_state of this PrivilegedApiControl.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PrivilegedApiControl.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this PrivilegedApiControl.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PrivilegedApiControl.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this PrivilegedApiControl.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this PrivilegedApiControl.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PrivilegedApiControl.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivilegedApiControl.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PrivilegedApiControl.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this PrivilegedApiControl.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PrivilegedApiControl.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivilegedApiControl.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PrivilegedApiControl.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivilegedApiControl.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivilegedApiControl.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivilegedApiControl.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivilegedApiControl.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
