# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportConfigurationDetails(object):
    """
    Array of configuration items with dependencies to import.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImportConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param configuration_items:
            The value to assign to the configuration_items property of this ImportConfigurationDetails.
        :type configuration_items: list[oci.apm_config.models.ExportImportConfigSummary]

        :param configuration_map:
            The value to assign to the configuration_map property of this ImportConfigurationDetails.
        :type configuration_map: dict(str, str)

        """
        self.swagger_types = {
            'configuration_items': 'list[ExportImportConfigSummary]',
            'configuration_map': 'dict(str, str)'
        }
        self.attribute_map = {
            'configuration_items': 'configurationItems',
            'configuration_map': 'configurationMap'
        }
        self._configuration_items = None
        self._configuration_map = None

    @property
    def configuration_items(self):
        """
        **[Required]** Gets the configuration_items of this ImportConfigurationDetails.
        A list of Configurations Details .


        :return: The configuration_items of this ImportConfigurationDetails.
        :rtype: list[oci.apm_config.models.ExportImportConfigSummary]
        """
        return self._configuration_items

    @configuration_items.setter
    def configuration_items(self, configuration_items):
        """
        Sets the configuration_items of this ImportConfigurationDetails.
        A list of Configurations Details .


        :param configuration_items: The configuration_items of this ImportConfigurationDetails.
        :type: list[oci.apm_config.models.ExportImportConfigSummary]
        """
        self._configuration_items = configuration_items

    @property
    def configuration_map(self):
        """
        **[Required]** Gets the configuration_map of this ImportConfigurationDetails.
        Simple key-value pair that has parameters related to the import process (EnableOcidSubstitution, Skip, \u2026) and more.
        Example: `{\"parameter-key\": \"parameter-value\"}`
        Supported parameters:
        \u2014 Enable the OCIDs in instructions to be replaced, if set to \"true\" The Config Service replace any OCIDs it finds
        in the instructions, if set to true the Config Service will replace.
        \u2014 Compartment Id we want to import the configuration Items,
        if the compartment Id is not provided it will be the default destination domain compartmentId.


        :return: The configuration_map of this ImportConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._configuration_map

    @configuration_map.setter
    def configuration_map(self, configuration_map):
        """
        Sets the configuration_map of this ImportConfigurationDetails.
        Simple key-value pair that has parameters related to the import process (EnableOcidSubstitution, Skip, \u2026) and more.
        Example: `{\"parameter-key\": \"parameter-value\"}`
        Supported parameters:
        \u2014 Enable the OCIDs in instructions to be replaced, if set to \"true\" The Config Service replace any OCIDs it finds
        in the instructions, if set to true the Config Service will replace.
        \u2014 Compartment Id we want to import the configuration Items,
        if the compartment Id is not provided it will be the default destination domain compartmentId.


        :param configuration_map: The configuration_map of this ImportConfigurationDetails.
        :type: dict(str, str)
        """
        self._configuration_map = configuration_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
