# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .update_config_details import UpdateConfigDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAgentConfigDetails(UpdateConfigDetails):
    """
    Agent configuration for any Agent complying with the OpAMP specification.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAgentConfigDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_config.models.UpdateAgentConfigDetails.config_type` attribute
        of this class is ``AGENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this UpdateAgentConfigDetails.
            Allowed values for this property are: "SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION"
        :type config_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAgentConfigDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAgentConfigDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param config:
            The value to assign to the config property of this UpdateAgentConfigDetails.
        :type config: oci.apm_config.models.AgentConfigMap

        :param overrides:
            The value to assign to the overrides property of this UpdateAgentConfigDetails.
        :type overrides: oci.apm_config.models.AgentConfigOverrides

        """
        self.swagger_types = {
            'config_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'config': 'AgentConfigMap',
            'overrides': 'AgentConfigOverrides'
        }
        self.attribute_map = {
            'config_type': 'configType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'config': 'config',
            'overrides': 'overrides'
        }
        self._config_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._config = None
        self._overrides = None
        self._config_type = 'AGENT'

    @property
    def config(self):
        """
        Gets the config of this UpdateAgentConfigDetails.

        :return: The config of this UpdateAgentConfigDetails.
        :rtype: oci.apm_config.models.AgentConfigMap
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this UpdateAgentConfigDetails.

        :param config: The config of this UpdateAgentConfigDetails.
        :type: oci.apm_config.models.AgentConfigMap
        """
        self._config = config

    @property
    def overrides(self):
        """
        Gets the overrides of this UpdateAgentConfigDetails.

        :return: The overrides of this UpdateAgentConfigDetails.
        :rtype: oci.apm_config.models.AgentConfigOverrides
        """
        return self._overrides

    @overrides.setter
    def overrides(self, overrides):
        """
        Sets the overrides of this UpdateAgentConfigDetails.

        :param overrides: The overrides of this UpdateAgentConfigDetails.
        :type: oci.apm_config.models.AgentConfigOverrides
        """
        self._overrides = overrides

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
