# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IamUserSyncConfigurationDetails(object):
    """
    Details for activating/updating an IAM user sync configuration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IamUserSyncConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_posix_attributes_addition_required:
            The value to assign to the is_posix_attributes_addition_required property of this IamUserSyncConfigurationDetails.
        :type is_posix_attributes_addition_required: bool

        """
        self.swagger_types = {
            'is_posix_attributes_addition_required': 'bool'
        }
        self.attribute_map = {
            'is_posix_attributes_addition_required': 'isPosixAttributesAdditionRequired'
        }
        self._is_posix_attributes_addition_required = None

    @property
    def is_posix_attributes_addition_required(self):
        """
        Gets the is_posix_attributes_addition_required of this IamUserSyncConfigurationDetails.
        whether posix attribute needs to be appended to users, required for updating IAM user sync configuration


        :return: The is_posix_attributes_addition_required of this IamUserSyncConfigurationDetails.
        :rtype: bool
        """
        return self._is_posix_attributes_addition_required

    @is_posix_attributes_addition_required.setter
    def is_posix_attributes_addition_required(self, is_posix_attributes_addition_required):
        """
        Sets the is_posix_attributes_addition_required of this IamUserSyncConfigurationDetails.
        whether posix attribute needs to be appended to users, required for updating IAM user sync configuration


        :param is_posix_attributes_addition_required: The is_posix_attributes_addition_required of this IamUserSyncConfigurationDetails.
        :type: bool
        """
        self._is_posix_attributes_addition_required = is_posix_attributes_addition_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
