# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181231


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class User(object):
    """
    Details about the user.
    """

    #: A constant which can be used with the problem_type property of a User.
    #: This constant has a value of "LIMIT"
    PROBLEM_TYPE_LIMIT = "LIMIT"

    #: A constant which can be used with the problem_type property of a User.
    #: This constant has a value of "LEGACY_LIMIT"
    PROBLEM_TYPE_LEGACY_LIMIT = "LEGACY_LIMIT"

    #: A constant which can be used with the problem_type property of a User.
    #: This constant has a value of "TECH"
    PROBLEM_TYPE_TECH = "TECH"

    #: A constant which can be used with the problem_type property of a User.
    #: This constant has a value of "ACCOUNT"
    PROBLEM_TYPE_ACCOUNT = "ACCOUNT"

    #: A constant which can be used with the problem_type property of a User.
    #: This constant has a value of "TAXONOMY"
    PROBLEM_TYPE_TAXONOMY = "TAXONOMY"

    def __init__(self, **kwargs):
        """
        Initializes a new User object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this User.
        :type key: str

        :param first_name:
            The value to assign to the first_name property of this User.
        :type first_name: str

        :param last_name:
            The value to assign to the last_name property of this User.
        :type last_name: str

        :param country:
            The value to assign to the country property of this User.
        :type country: str

        :param csi:
            The value to assign to the csi property of this User.
        :type csi: str

        :param phone:
            The value to assign to the phone property of this User.
        :type phone: str

        :param timezone:
            The value to assign to the timezone property of this User.
        :type timezone: str

        :param organization_name:
            The value to assign to the organization_name property of this User.
        :type organization_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this User.
        :type compartment_id: str

        :param contact_email:
            The value to assign to the contact_email property of this User.
        :type contact_email: str

        :param problem_type:
            The value to assign to the problem_type property of this User.
            Allowed values for this property are: "LIMIT", "LEGACY_LIMIT", "TECH", "ACCOUNT", "TAXONOMY"
        :type problem_type: str

        """
        self.swagger_types = {
            'key': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'country': 'str',
            'csi': 'str',
            'phone': 'str',
            'timezone': 'str',
            'organization_name': 'str',
            'compartment_id': 'str',
            'contact_email': 'str',
            'problem_type': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'country': 'country',
            'csi': 'csi',
            'phone': 'phone',
            'timezone': 'timezone',
            'organization_name': 'organizationName',
            'compartment_id': 'compartmentId',
            'contact_email': 'contactEmail',
            'problem_type': 'problemType'
        }
        self._key = None
        self._first_name = None
        self._last_name = None
        self._country = None
        self._csi = None
        self._phone = None
        self._timezone = None
        self._organization_name = None
        self._compartment_id = None
        self._contact_email = None
        self._problem_type = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this User.
        A unique identifier for the user.


        :return: The key of this User.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this User.
        A unique identifier for the user.


        :param key: The key of this User.
        :type: str
        """
        self._key = key

    @property
    def first_name(self):
        """
        Gets the first_name of this User.
        The user's first name.


        :return: The first_name of this User.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this User.
        The user's first name.


        :param first_name: The first_name of this User.
        :type: str
        """
        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this User.
        The user's last name.


        :return: The last_name of this User.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this User.
        The user's last name.


        :param last_name: The last_name of this User.
        :type: str
        """
        self._last_name = last_name

    @property
    def country(self):
        """
        Gets the country of this User.
        The country of the user.


        :return: The country of this User.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this User.
        The country of the user.


        :param country: The country of this User.
        :type: str
        """
        self._country = country

    @property
    def csi(self):
        """
        Gets the csi of this User.
        The CSI associated with the user.


        :return: The csi of this User.
        :rtype: str
        """
        return self._csi

    @csi.setter
    def csi(self, csi):
        """
        Sets the csi of this User.
        The CSI associated with the user.


        :param csi: The csi of this User.
        :type: str
        """
        self._csi = csi

    @property
    def phone(self):
        """
        Gets the phone of this User.
        The user's contact phone number.


        :return: The phone of this User.
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """
        Sets the phone of this User.
        The user's contact phone number.


        :param phone: The phone of this User.
        :type: str
        """
        self._phone = phone

    @property
    def timezone(self):
        """
        Gets the timezone of this User.
        The timezone of the user.


        :return: The timezone of this User.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this User.
        The timezone of the user.


        :param timezone: The timezone of this User.
        :type: str
        """
        self._timezone = timezone

    @property
    def organization_name(self):
        """
        Gets the organization_name of this User.
        The company that the user belongs to.


        :return: The organization_name of this User.
        :rtype: str
        """
        return self._organization_name

    @organization_name.setter
    def organization_name(self, organization_name):
        """
        Sets the organization_name of this User.
        The company that the user belongs to.


        :param organization_name: The organization_name of this User.
        :type: str
        """
        self._organization_name = organization_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this User.
        The OCID of the tenancy.


        :return: The compartment_id of this User.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this User.
        The OCID of the tenancy.


        :param compartment_id: The compartment_id of this User.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def contact_email(self):
        """
        Gets the contact_email of this User.
        The email of the contact person.


        :return: The contact_email of this User.
        :rtype: str
        """
        return self._contact_email

    @contact_email.setter
    def contact_email(self, contact_email):
        """
        Sets the contact_email of this User.
        The email of the contact person.


        :param contact_email: The contact_email of this User.
        :type: str
        """
        self._contact_email = contact_email

    @property
    def problem_type(self):
        """
        Gets the problem_type of this User.
        The kind of support request (type of support request).
        For information about `ACCOUNT` support requests, see
        `Creating a Billing Support Request`__.
        For information about `LIMIT` support requests, see
        `Creating a Service Limit Increase Request`__.
        For information about `TECH` support requests, see
        `Creating a Technical Support Request`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-billing.htm
        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-limit.htm
        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-technical.htm

        Allowed values for this property are: "LIMIT", "LEGACY_LIMIT", "TECH", "ACCOUNT", "TAXONOMY"


        :return: The problem_type of this User.
        :rtype: str
        """
        return self._problem_type

    @problem_type.setter
    def problem_type(self, problem_type):
        """
        Sets the problem_type of this User.
        The kind of support request (type of support request).
        For information about `ACCOUNT` support requests, see
        `Creating a Billing Support Request`__.
        For information about `LIMIT` support requests, see
        `Creating a Service Limit Increase Request`__.
        For information about `TECH` support requests, see
        `Creating a Technical Support Request`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-billing.htm
        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-limit.htm
        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident-technical.htm


        :param problem_type: The problem_type of this User.
        :type: str
        """
        allowed_values = ["LIMIT", "LEGACY_LIMIT", "TECH", "ACCOUNT", "TAXONOMY"]
        if not value_allowed_none_or_none_sentinel(problem_type, allowed_values):
            raise ValueError(
                f"Invalid value for `problem_type`, must be None or one of {allowed_values}"
            )
        self._problem_type = problem_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
