# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CapabilityDetails(object):
    """
    Details about the supported type of resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CapabilityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service:
            The value to assign to the service property of this CapabilityDetails.
        :type service: str

        :param name:
            The value to assign to the name property of this CapabilityDetails.
        :type name: str

        """
        self.swagger_types = {
            'service': 'str',
            'name': 'str'
        }
        self.attribute_map = {
            'service': 'service',
            'name': 'name'
        }
        self._service = None
        self._name = None

    @property
    def service(self):
        """
        **[Required]** Gets the service of this CapabilityDetails.
        The service that the resource is part of.


        :return: The service of this CapabilityDetails.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this CapabilityDetails.
        The service that the resource is part of.


        :param service: The service of this CapabilityDetails.
        :type: str
        """
        self._service = service

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CapabilityDetails.
        The type of resource.


        :return: The name of this CapabilityDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CapabilityDetails.
        The type of resource.


        :param name: The name of this CapabilityDetails.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
