# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrgCustomerResource(object):
    """
    The IPSEC / FC / RPC info returned in DrgCustomerResponse
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrgCustomerResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DrgCustomerResource.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DrgCustomerResource.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DrgCustomerResource.
        :type compartment_id: str

        :param state:
            The value to assign to the state property of this DrgCustomerResource.
        :type state: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'state': 'state'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._state = None

    @property
    def id(self):
        """
        Gets the id of this DrgCustomerResource.
        OCID of the IPSEC / FC / RPC


        :return: The id of this DrgCustomerResource.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DrgCustomerResource.
        OCID of the IPSEC / FC / RPC


        :param id: The id of this DrgCustomerResource.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this DrgCustomerResource.
        The friendly name of the node.


        :return: The display_name of this DrgCustomerResource.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DrgCustomerResource.
        The friendly name of the node.


        :param display_name: The display_name of this DrgCustomerResource.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this DrgCustomerResource.
        the compartment id of the DRG


        :return: The compartment_id of this DrgCustomerResource.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DrgCustomerResource.
        the compartment id of the DRG


        :param compartment_id: The compartment_id of this DrgCustomerResource.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def state(self):
        """
        Gets the state of this DrgCustomerResource.
        the lifeCycleState of the IPSEC / FC / RPC


        :return: The state of this DrgCustomerResource.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this DrgCustomerResource.
        the lifeCycleState of the IPSEC / FC / RPC


        :param state: The state of this DrgCustomerResource.
        :type: str
        """
        self._state = state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
