# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .entry_details import EntryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AuditPolicyEntryDetails(EntryDetails):
    """
    Audit policy details.
    """

    #: A constant which can be used with the datasafe_user_exclusion_status property of a AuditPolicyEntryDetails.
    #: This constant has a value of "EXCLUDED_SUCCESS"
    DATASAFE_USER_EXCLUSION_STATUS_EXCLUDED_SUCCESS = "EXCLUDED_SUCCESS"

    #: A constant which can be used with the datasafe_user_exclusion_status property of a AuditPolicyEntryDetails.
    #: This constant has a value of "EXCLUDED_FAILED"
    DATASAFE_USER_EXCLUSION_STATUS_EXCLUDED_FAILED = "EXCLUDED_FAILED"

    #: A constant which can be used with the datasafe_user_exclusion_status property of a AuditPolicyEntryDetails.
    #: This constant has a value of "NOT_EXCLUDED"
    DATASAFE_USER_EXCLUSION_STATUS_NOT_EXCLUDED = "NOT_EXCLUDED"

    def __init__(self, **kwargs):
        """
        Initializes a new AuditPolicyEntryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.AuditPolicyEntryDetails.entry_type` attribute
        of this class is ``AUDIT_POLICY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entry_type:
            The value to assign to the entry_type property of this AuditPolicyEntryDetails.
            Allowed values for this property are: "FIREWALL_POLICY", "AUDIT_POLICY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type entry_type: str

        :param datasafe_user_exclusion_status:
            The value to assign to the datasafe_user_exclusion_status property of this AuditPolicyEntryDetails.
            Allowed values for this property are: "EXCLUDED_SUCCESS", "EXCLUDED_FAILED", "NOT_EXCLUDED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type datasafe_user_exclusion_status: str

        :param exclude_datasafe_user_failure_msg:
            The value to assign to the exclude_datasafe_user_failure_msg property of this AuditPolicyEntryDetails.
        :type exclude_datasafe_user_failure_msg: str

        """
        self.swagger_types = {
            'entry_type': 'str',
            'datasafe_user_exclusion_status': 'str',
            'exclude_datasafe_user_failure_msg': 'str'
        }
        self.attribute_map = {
            'entry_type': 'entryType',
            'datasafe_user_exclusion_status': 'datasafeUserExclusionStatus',
            'exclude_datasafe_user_failure_msg': 'excludeDatasafeUserFailureMsg'
        }
        self._entry_type = None
        self._datasafe_user_exclusion_status = None
        self._exclude_datasafe_user_failure_msg = None
        self._entry_type = 'AUDIT_POLICY'

    @property
    def datasafe_user_exclusion_status(self):
        """
        **[Required]** Gets the datasafe_user_exclusion_status of this AuditPolicyEntryDetails.
        The status of Data Safe user exclusion in the audit policy.

        Allowed values for this property are: "EXCLUDED_SUCCESS", "EXCLUDED_FAILED", "NOT_EXCLUDED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The datasafe_user_exclusion_status of this AuditPolicyEntryDetails.
        :rtype: str
        """
        return self._datasafe_user_exclusion_status

    @datasafe_user_exclusion_status.setter
    def datasafe_user_exclusion_status(self, datasafe_user_exclusion_status):
        """
        Sets the datasafe_user_exclusion_status of this AuditPolicyEntryDetails.
        The status of Data Safe user exclusion in the audit policy.


        :param datasafe_user_exclusion_status: The datasafe_user_exclusion_status of this AuditPolicyEntryDetails.
        :type: str
        """
        allowed_values = ["EXCLUDED_SUCCESS", "EXCLUDED_FAILED", "NOT_EXCLUDED"]
        if not value_allowed_none_or_none_sentinel(datasafe_user_exclusion_status, allowed_values):
            datasafe_user_exclusion_status = 'UNKNOWN_ENUM_VALUE'
        self._datasafe_user_exclusion_status = datasafe_user_exclusion_status

    @property
    def exclude_datasafe_user_failure_msg(self):
        """
        Gets the exclude_datasafe_user_failure_msg of this AuditPolicyEntryDetails.
        Specifies why exclusion of the Data Safe user did not succeed.


        :return: The exclude_datasafe_user_failure_msg of this AuditPolicyEntryDetails.
        :rtype: str
        """
        return self._exclude_datasafe_user_failure_msg

    @exclude_datasafe_user_failure_msg.setter
    def exclude_datasafe_user_failure_msg(self, exclude_datasafe_user_failure_msg):
        """
        Sets the exclude_datasafe_user_failure_msg of this AuditPolicyEntryDetails.
        Specifies why exclusion of the Data Safe user did not succeed.


        :param exclude_datasafe_user_failure_msg: The exclude_datasafe_user_failure_msg of this AuditPolicyEntryDetails.
        :type: str
        """
        self._exclude_datasafe_user_failure_msg = exclude_datasafe_user_failure_msg

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
