# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkDeleteSqlFirewallAllowedSqlsDetails(object):
    """
    Details of the allowed SQLs to be deleted from the SQL firewall policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkDeleteSqlFirewallAllowedSqlsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sql_firewall_policy_id:
            The value to assign to the sql_firewall_policy_id property of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :type sql_firewall_policy_id: str

        :param selection:
            The value to assign to the selection property of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :type selection: oci.data_safe.models.SelectionDetails

        """
        self.swagger_types = {
            'sql_firewall_policy_id': 'str',
            'selection': 'SelectionDetails'
        }
        self.attribute_map = {
            'sql_firewall_policy_id': 'sqlFirewallPolicyId',
            'selection': 'selection'
        }
        self._sql_firewall_policy_id = None
        self._selection = None

    @property
    def sql_firewall_policy_id(self):
        """
        **[Required]** Gets the sql_firewall_policy_id of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        The OCID of the SQL firewall policy whose allowed SQLs needs to be deleted.


        :return: The sql_firewall_policy_id of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :rtype: str
        """
        return self._sql_firewall_policy_id

    @sql_firewall_policy_id.setter
    def sql_firewall_policy_id(self, sql_firewall_policy_id):
        """
        Sets the sql_firewall_policy_id of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        The OCID of the SQL firewall policy whose allowed SQLs needs to be deleted.


        :param sql_firewall_policy_id: The sql_firewall_policy_id of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :type: str
        """
        self._sql_firewall_policy_id = sql_firewall_policy_id

    @property
    def selection(self):
        """
        **[Required]** Gets the selection of this BulkDeleteSqlFirewallAllowedSqlsDetails.

        :return: The selection of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :rtype: oci.data_safe.models.SelectionDetails
        """
        return self._selection

    @selection.setter
    def selection(self, selection):
        """
        Sets the selection of this BulkDeleteSqlFirewallAllowedSqlsDetails.

        :param selection: The selection of this BulkDeleteSqlFirewallAllowedSqlsDetails.
        :type: oci.data_safe.models.SelectionDetails
        """
        self._selection = selection

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
