# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaskingPolicyHealthReportLogSummary(object):
    """
    A log entry related to the pre-masking health check.
    """

    #: A constant which can be used with the message_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "PASS"
    MESSAGE_TYPE_PASS = "PASS"

    #: A constant which can be used with the message_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "WARNING"
    MESSAGE_TYPE_WARNING = "WARNING"

    #: A constant which can be used with the message_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "ERROR"
    MESSAGE_TYPE_ERROR = "ERROR"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "INVALID_OBJECT_CHECK"
    HEALTH_CHECK_TYPE_INVALID_OBJECT_CHECK = "INVALID_OBJECT_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "PRIVILEGE_CHECK"
    HEALTH_CHECK_TYPE_PRIVILEGE_CHECK = "PRIVILEGE_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "TABLESPACE_CHECK"
    HEALTH_CHECK_TYPE_TABLESPACE_CHECK = "TABLESPACE_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "DATABASE_OR_SYSTEM_TRIGGERS_CHECK"
    HEALTH_CHECK_TYPE_DATABASE_OR_SYSTEM_TRIGGERS_CHECK = "DATABASE_OR_SYSTEM_TRIGGERS_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "UNDO_TABLESPACE_CHECK"
    HEALTH_CHECK_TYPE_UNDO_TABLESPACE_CHECK = "UNDO_TABLESPACE_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "STATE_STATS_CHECK"
    HEALTH_CHECK_TYPE_STATE_STATS_CHECK = "STATE_STATS_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "OLS_POLICY_CHECK"
    HEALTH_CHECK_TYPE_OLS_POLICY_CHECK = "OLS_POLICY_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "VPD_POLICY_CHECK"
    HEALTH_CHECK_TYPE_VPD_POLICY_CHECK = "VPD_POLICY_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "DV_ENABLE_CHECK"
    HEALTH_CHECK_TYPE_DV_ENABLE_CHECK = "DV_ENABLE_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "DE_COL_SIZE_CHECK"
    HEALTH_CHECK_TYPE_DE_COL_SIZE_CHECK = "DE_COL_SIZE_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "REDACTION_POLICY_CHECK"
    HEALTH_CHECK_TYPE_REDACTION_POLICY_CHECK = "REDACTION_POLICY_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "ACTIVE_MASK_JOB_CHECK"
    HEALTH_CHECK_TYPE_ACTIVE_MASK_JOB_CHECK = "ACTIVE_MASK_JOB_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "TARGET_VALIDATION_CHECK"
    HEALTH_CHECK_TYPE_TARGET_VALIDATION_CHECK = "TARGET_VALIDATION_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "DETERMINISTIC_ENCRYPTION_FORMAT_CHECK"
    HEALTH_CHECK_TYPE_DETERMINISTIC_ENCRYPTION_FORMAT_CHECK = "DETERMINISTIC_ENCRYPTION_FORMAT_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "COLUMN_EXIST_CHECK"
    HEALTH_CHECK_TYPE_COLUMN_EXIST_CHECK = "COLUMN_EXIST_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "TIME_TRAVEL_CHECK"
    HEALTH_CHECK_TYPE_TIME_TRAVEL_CHECK = "TIME_TRAVEL_CHECK"

    #: A constant which can be used with the health_check_type property of a MaskingPolicyHealthReportLogSummary.
    #: This constant has a value of "INVALID_PACKAGE_CHECK"
    HEALTH_CHECK_TYPE_INVALID_PACKAGE_CHECK = "INVALID_PACKAGE_CHECK"

    def __init__(self, **kwargs):
        """
        Initializes a new MaskingPolicyHealthReportLogSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param message_type:
            The value to assign to the message_type property of this MaskingPolicyHealthReportLogSummary.
            Allowed values for this property are: "PASS", "WARNING", "ERROR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type message_type: str

        :param timestamp:
            The value to assign to the timestamp property of this MaskingPolicyHealthReportLogSummary.
        :type timestamp: datetime

        :param message:
            The value to assign to the message property of this MaskingPolicyHealthReportLogSummary.
        :type message: str

        :param remediation:
            The value to assign to the remediation property of this MaskingPolicyHealthReportLogSummary.
        :type remediation: str

        :param description:
            The value to assign to the description property of this MaskingPolicyHealthReportLogSummary.
        :type description: str

        :param health_check_type:
            The value to assign to the health_check_type property of this MaskingPolicyHealthReportLogSummary.
            Allowed values for this property are: "INVALID_OBJECT_CHECK", "PRIVILEGE_CHECK", "TABLESPACE_CHECK", "DATABASE_OR_SYSTEM_TRIGGERS_CHECK", "UNDO_TABLESPACE_CHECK", "STATE_STATS_CHECK", "OLS_POLICY_CHECK", "VPD_POLICY_CHECK", "DV_ENABLE_CHECK", "DE_COL_SIZE_CHECK", "REDACTION_POLICY_CHECK", "ACTIVE_MASK_JOB_CHECK", "TARGET_VALIDATION_CHECK", "DETERMINISTIC_ENCRYPTION_FORMAT_CHECK", "COLUMN_EXIST_CHECK", "TIME_TRAVEL_CHECK", "INVALID_PACKAGE_CHECK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type health_check_type: str

        """
        self.swagger_types = {
            'message_type': 'str',
            'timestamp': 'datetime',
            'message': 'str',
            'remediation': 'str',
            'description': 'str',
            'health_check_type': 'str'
        }
        self.attribute_map = {
            'message_type': 'messageType',
            'timestamp': 'timestamp',
            'message': 'message',
            'remediation': 'remediation',
            'description': 'description',
            'health_check_type': 'healthCheckType'
        }
        self._message_type = None
        self._timestamp = None
        self._message = None
        self._remediation = None
        self._description = None
        self._health_check_type = None

    @property
    def message_type(self):
        """
        **[Required]** Gets the message_type of this MaskingPolicyHealthReportLogSummary.
        The log entry type.

        Allowed values for this property are: "PASS", "WARNING", "ERROR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The message_type of this MaskingPolicyHealthReportLogSummary.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type):
        """
        Sets the message_type of this MaskingPolicyHealthReportLogSummary.
        The log entry type.


        :param message_type: The message_type of this MaskingPolicyHealthReportLogSummary.
        :type: str
        """
        allowed_values = ["PASS", "WARNING", "ERROR"]
        if not value_allowed_none_or_none_sentinel(message_type, allowed_values):
            message_type = 'UNKNOWN_ENUM_VALUE'
        self._message_type = message_type

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this MaskingPolicyHealthReportLogSummary.
        The date and time the log entry was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The timestamp of this MaskingPolicyHealthReportLogSummary.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this MaskingPolicyHealthReportLogSummary.
        The date and time the log entry was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param timestamp: The timestamp of this MaskingPolicyHealthReportLogSummary.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def message(self):
        """
        **[Required]** Gets the message of this MaskingPolicyHealthReportLogSummary.
        A human-readable log entry.


        :return: The message of this MaskingPolicyHealthReportLogSummary.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this MaskingPolicyHealthReportLogSummary.
        A human-readable log entry.


        :param message: The message of this MaskingPolicyHealthReportLogSummary.
        :type: str
        """
        self._message = message

    @property
    def remediation(self):
        """
        Gets the remediation of this MaskingPolicyHealthReportLogSummary.
        A human-readable log entry to remedy any error or warnings in the masking policy.


        :return: The remediation of this MaskingPolicyHealthReportLogSummary.
        :rtype: str
        """
        return self._remediation

    @remediation.setter
    def remediation(self, remediation):
        """
        Sets the remediation of this MaskingPolicyHealthReportLogSummary.
        A human-readable log entry to remedy any error or warnings in the masking policy.


        :param remediation: The remediation of this MaskingPolicyHealthReportLogSummary.
        :type: str
        """
        self._remediation = remediation

    @property
    def description(self):
        """
        **[Required]** Gets the description of this MaskingPolicyHealthReportLogSummary.
        A human-readable description for the log entry.


        :return: The description of this MaskingPolicyHealthReportLogSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MaskingPolicyHealthReportLogSummary.
        A human-readable description for the log entry.


        :param description: The description of this MaskingPolicyHealthReportLogSummary.
        :type: str
        """
        self._description = description

    @property
    def health_check_type(self):
        """
        Gets the health_check_type of this MaskingPolicyHealthReportLogSummary.
        An enum type entry for each health check in the masking policy. Each enum describes a type of health check.
        INVALID_OBJECT_CHECK checks if there exist any invalid objects in the masking tables.
        PRIVILEGE_CHECK checks if the masking user has sufficient privilege to run masking.
        TABLESPACE_CHECK checks if the user has sufficient default and TEMP tablespace. Also verifies that the specified tablespace by the user is valid, if user has provided one
        DATABASE_OR_SYSTEM_TRIGGERS_CHECK checks if there exist any database/system triggers available.
        UNDO_TABLESPACE_CHECK checks if for all the instances of undo tablespace the AUTOEXTEND feature is enabled.
        If it's not enabled, it further checks if the undo tablespace has any space remaining.
        STATE_STATS_CHECK checks if all the statistics of the masking table is upto date or not.
        OLS_POLICY_CHECK , VPD_POLICY_CHECK and REDACTION_POLICY_CHECK checks if the masking tables has Oracle Label Security (OLS) or Virtual Private Database (VPD) or Redaction policies enabled.
        DV_ENABLE_CHECK checks if database has Database Vault(DV) enabled
        DE_COL_SIZE_CHECK checks if any masking column with DETERMINISTIC ENCRYPTION as masking format has average column size greater than 27 or not.
        ACTIVE_MASK_JOB_CHECK checks if there is any active masking job running on the target database.
        DETERMINISTIC_ENCRYPTION_FORMAT_CHECK checks if any masking column has deterministic encryption masking format.
        COLUMN_EXIST_CHECK checks if the masking columns are available in the target database.
        TIME_TRAVEL_CHECK checks if the masking tables have Time Travel enabled.
        INVALID_PACKAGE_CHECK checks if any of the required packages are in invalid state.

        Allowed values for this property are: "INVALID_OBJECT_CHECK", "PRIVILEGE_CHECK", "TABLESPACE_CHECK", "DATABASE_OR_SYSTEM_TRIGGERS_CHECK", "UNDO_TABLESPACE_CHECK", "STATE_STATS_CHECK", "OLS_POLICY_CHECK", "VPD_POLICY_CHECK", "DV_ENABLE_CHECK", "DE_COL_SIZE_CHECK", "REDACTION_POLICY_CHECK", "ACTIVE_MASK_JOB_CHECK", "TARGET_VALIDATION_CHECK", "DETERMINISTIC_ENCRYPTION_FORMAT_CHECK", "COLUMN_EXIST_CHECK", "TIME_TRAVEL_CHECK", "INVALID_PACKAGE_CHECK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The health_check_type of this MaskingPolicyHealthReportLogSummary.
        :rtype: str
        """
        return self._health_check_type

    @health_check_type.setter
    def health_check_type(self, health_check_type):
        """
        Sets the health_check_type of this MaskingPolicyHealthReportLogSummary.
        An enum type entry for each health check in the masking policy. Each enum describes a type of health check.
        INVALID_OBJECT_CHECK checks if there exist any invalid objects in the masking tables.
        PRIVILEGE_CHECK checks if the masking user has sufficient privilege to run masking.
        TABLESPACE_CHECK checks if the user has sufficient default and TEMP tablespace. Also verifies that the specified tablespace by the user is valid, if user has provided one
        DATABASE_OR_SYSTEM_TRIGGERS_CHECK checks if there exist any database/system triggers available.
        UNDO_TABLESPACE_CHECK checks if for all the instances of undo tablespace the AUTOEXTEND feature is enabled.
        If it's not enabled, it further checks if the undo tablespace has any space remaining.
        STATE_STATS_CHECK checks if all the statistics of the masking table is upto date or not.
        OLS_POLICY_CHECK , VPD_POLICY_CHECK and REDACTION_POLICY_CHECK checks if the masking tables has Oracle Label Security (OLS) or Virtual Private Database (VPD) or Redaction policies enabled.
        DV_ENABLE_CHECK checks if database has Database Vault(DV) enabled
        DE_COL_SIZE_CHECK checks if any masking column with DETERMINISTIC ENCRYPTION as masking format has average column size greater than 27 or not.
        ACTIVE_MASK_JOB_CHECK checks if there is any active masking job running on the target database.
        DETERMINISTIC_ENCRYPTION_FORMAT_CHECK checks if any masking column has deterministic encryption masking format.
        COLUMN_EXIST_CHECK checks if the masking columns are available in the target database.
        TIME_TRAVEL_CHECK checks if the masking tables have Time Travel enabled.
        INVALID_PACKAGE_CHECK checks if any of the required packages are in invalid state.


        :param health_check_type: The health_check_type of this MaskingPolicyHealthReportLogSummary.
        :type: str
        """
        allowed_values = ["INVALID_OBJECT_CHECK", "PRIVILEGE_CHECK", "TABLESPACE_CHECK", "DATABASE_OR_SYSTEM_TRIGGERS_CHECK", "UNDO_TABLESPACE_CHECK", "STATE_STATS_CHECK", "OLS_POLICY_CHECK", "VPD_POLICY_CHECK", "DV_ENABLE_CHECK", "DE_COL_SIZE_CHECK", "REDACTION_POLICY_CHECK", "ACTIVE_MASK_JOB_CHECK", "TARGET_VALIDATION_CHECK", "DETERMINISTIC_ENCRYPTION_FORMAT_CHECK", "COLUMN_EXIST_CHECK", "TIME_TRAVEL_CHECK", "INVALID_PACKAGE_CHECK"]
        if not value_allowed_none_or_none_sentinel(health_check_type, allowed_values):
            health_check_type = 'UNKNOWN_ENUM_VALUE'
        self._health_check_type = health_check_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
