# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateAnalyticsDimensions(object):
    """
    The scope of analytics data.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateAnalyticsDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param template_assessment_id:
            The value to assign to the template_assessment_id property of this TemplateAnalyticsDimensions.
        :type template_assessment_id: str

        :param total_checks:
            The value to assign to the total_checks property of this TemplateAnalyticsDimensions.
        :type total_checks: int

        :param template_baseline_assessment_id:
            The value to assign to the template_baseline_assessment_id property of this TemplateAnalyticsDimensions.
        :type template_baseline_assessment_id: str

        :param target_id:
            The value to assign to the target_id property of this TemplateAnalyticsDimensions.
        :type target_id: str

        :param target_database_group_id:
            The value to assign to the target_database_group_id property of this TemplateAnalyticsDimensions.
        :type target_database_group_id: str

        :param is_group:
            The value to assign to the is_group property of this TemplateAnalyticsDimensions.
        :type is_group: bool

        :param is_compared:
            The value to assign to the is_compared property of this TemplateAnalyticsDimensions.
        :type is_compared: bool

        :param time_last_compared:
            The value to assign to the time_last_compared property of this TemplateAnalyticsDimensions.
        :type time_last_compared: datetime

        :param is_compliant:
            The value to assign to the is_compliant property of this TemplateAnalyticsDimensions.
        :type is_compliant: bool

        :param total_checks_failed:
            The value to assign to the total_checks_failed property of this TemplateAnalyticsDimensions.
        :type total_checks_failed: int

        :param total_targets:
            The value to assign to the total_targets property of this TemplateAnalyticsDimensions.
        :type total_targets: int

        :param total_non_compliant_targets:
            The value to assign to the total_non_compliant_targets property of this TemplateAnalyticsDimensions.
        :type total_non_compliant_targets: int

        """
        self.swagger_types = {
            'template_assessment_id': 'str',
            'total_checks': 'int',
            'template_baseline_assessment_id': 'str',
            'target_id': 'str',
            'target_database_group_id': 'str',
            'is_group': 'bool',
            'is_compared': 'bool',
            'time_last_compared': 'datetime',
            'is_compliant': 'bool',
            'total_checks_failed': 'int',
            'total_targets': 'int',
            'total_non_compliant_targets': 'int'
        }
        self.attribute_map = {
            'template_assessment_id': 'templateAssessmentId',
            'total_checks': 'totalChecks',
            'template_baseline_assessment_id': 'templateBaselineAssessmentId',
            'target_id': 'targetId',
            'target_database_group_id': 'targetDatabaseGroupId',
            'is_group': 'isGroup',
            'is_compared': 'isCompared',
            'time_last_compared': 'timeLastCompared',
            'is_compliant': 'isCompliant',
            'total_checks_failed': 'totalChecksFailed',
            'total_targets': 'totalTargets',
            'total_non_compliant_targets': 'totalNonCompliantTargets'
        }
        self._template_assessment_id = None
        self._total_checks = None
        self._template_baseline_assessment_id = None
        self._target_id = None
        self._target_database_group_id = None
        self._is_group = None
        self._is_compared = None
        self._time_last_compared = None
        self._is_compliant = None
        self._total_checks_failed = None
        self._total_targets = None
        self._total_non_compliant_targets = None

    @property
    def template_assessment_id(self):
        """
        Gets the template_assessment_id of this TemplateAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE.


        :return: The template_assessment_id of this TemplateAnalyticsDimensions.
        :rtype: str
        """
        return self._template_assessment_id

    @template_assessment_id.setter
    def template_assessment_id(self, template_assessment_id):
        """
        Sets the template_assessment_id of this TemplateAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE.


        :param template_assessment_id: The template_assessment_id of this TemplateAnalyticsDimensions.
        :type: str
        """
        self._template_assessment_id = template_assessment_id

    @property
    def total_checks(self):
        """
        Gets the total_checks of this TemplateAnalyticsDimensions.
        The number of checks inside the template assessment.


        :return: The total_checks of this TemplateAnalyticsDimensions.
        :rtype: int
        """
        return self._total_checks

    @total_checks.setter
    def total_checks(self, total_checks):
        """
        Sets the total_checks of this TemplateAnalyticsDimensions.
        The number of checks inside the template assessment.


        :param total_checks: The total_checks of this TemplateAnalyticsDimensions.
        :type: int
        """
        self._total_checks = total_checks

    @property
    def template_baseline_assessment_id(self):
        """
        Gets the template_baseline_assessment_id of this TemplateAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE_BASELINE.


        :return: The template_baseline_assessment_id of this TemplateAnalyticsDimensions.
        :rtype: str
        """
        return self._template_baseline_assessment_id

    @template_baseline_assessment_id.setter
    def template_baseline_assessment_id(self, template_baseline_assessment_id):
        """
        Sets the template_baseline_assessment_id of this TemplateAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE_BASELINE.


        :param template_baseline_assessment_id: The template_baseline_assessment_id of this TemplateAnalyticsDimensions.
        :type: str
        """
        self._template_baseline_assessment_id = template_baseline_assessment_id

    @property
    def target_id(self):
        """
        Gets the target_id of this TemplateAnalyticsDimensions.
        The OCID of the target database. This field will be in the response if the template was applied on an individual target.


        :return: The target_id of this TemplateAnalyticsDimensions.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this TemplateAnalyticsDimensions.
        The OCID of the target database. This field will be in the response if the template was applied on an individual target.


        :param target_id: The target_id of this TemplateAnalyticsDimensions.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_database_group_id(self):
        """
        Gets the target_database_group_id of this TemplateAnalyticsDimensions.
        The OCID of the target database group that the group assessment is created for.
        This field will be in the response if the template was applied on a target group.


        :return: The target_database_group_id of this TemplateAnalyticsDimensions.
        :rtype: str
        """
        return self._target_database_group_id

    @target_database_group_id.setter
    def target_database_group_id(self, target_database_group_id):
        """
        Sets the target_database_group_id of this TemplateAnalyticsDimensions.
        The OCID of the target database group that the group assessment is created for.
        This field will be in the response if the template was applied on a target group.


        :param target_database_group_id: The target_database_group_id of this TemplateAnalyticsDimensions.
        :type: str
        """
        self._target_database_group_id = target_database_group_id

    @property
    def is_group(self):
        """
        Gets the is_group of this TemplateAnalyticsDimensions.
        Indicates whether or not the template security assessment is applied to a target group.
        If the value is false, it means the template security assessment is applied to a individual target.


        :return: The is_group of this TemplateAnalyticsDimensions.
        :rtype: bool
        """
        return self._is_group

    @is_group.setter
    def is_group(self, is_group):
        """
        Sets the is_group of this TemplateAnalyticsDimensions.
        Indicates whether or not the template security assessment is applied to a target group.
        If the value is false, it means the template security assessment is applied to a individual target.


        :param is_group: The is_group of this TemplateAnalyticsDimensions.
        :type: bool
        """
        self._is_group = is_group

    @property
    def is_compared(self):
        """
        Gets the is_compared of this TemplateAnalyticsDimensions.
        Indicates whether or not the comparison between the latest assessment and the template baseline assessment is done.
        If the value is false, it means the comparison is not done yet.


        :return: The is_compared of this TemplateAnalyticsDimensions.
        :rtype: bool
        """
        return self._is_compared

    @is_compared.setter
    def is_compared(self, is_compared):
        """
        Sets the is_compared of this TemplateAnalyticsDimensions.
        Indicates whether or not the comparison between the latest assessment and the template baseline assessment is done.
        If the value is false, it means the comparison is not done yet.


        :param is_compared: The is_compared of this TemplateAnalyticsDimensions.
        :type: bool
        """
        self._is_compared = is_compared

    @property
    def time_last_compared(self):
        """
        Gets the time_last_compared of this TemplateAnalyticsDimensions.
        The date and time when the comparison was made upon the template baseline. Conforms to the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_compared of this TemplateAnalyticsDimensions.
        :rtype: datetime
        """
        return self._time_last_compared

    @time_last_compared.setter
    def time_last_compared(self, time_last_compared):
        """
        Sets the time_last_compared of this TemplateAnalyticsDimensions.
        The date and time when the comparison was made upon the template baseline. Conforms to the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_compared: The time_last_compared of this TemplateAnalyticsDimensions.
        :type: datetime
        """
        self._time_last_compared = time_last_compared

    @property
    def is_compliant(self):
        """
        Gets the is_compliant of this TemplateAnalyticsDimensions.
        Indicates whether or not the latest assessment is compliant with the template baseline assessment.
        If the value is false, it means there is drift in the comparison report and the totalChecksFailed field will have a non-zero value.


        :return: The is_compliant of this TemplateAnalyticsDimensions.
        :rtype: bool
        """
        return self._is_compliant

    @is_compliant.setter
    def is_compliant(self, is_compliant):
        """
        Sets the is_compliant of this TemplateAnalyticsDimensions.
        Indicates whether or not the latest assessment is compliant with the template baseline assessment.
        If the value is false, it means there is drift in the comparison report and the totalChecksFailed field will have a non-zero value.


        :param is_compliant: The is_compliant of this TemplateAnalyticsDimensions.
        :type: bool
        """
        self._is_compliant = is_compliant

    @property
    def total_checks_failed(self):
        """
        Gets the total_checks_failed of this TemplateAnalyticsDimensions.
        Indicates how many checks in the template have drifts in the comparison report. This field is only present if isCompliant is false.


        :return: The total_checks_failed of this TemplateAnalyticsDimensions.
        :rtype: int
        """
        return self._total_checks_failed

    @total_checks_failed.setter
    def total_checks_failed(self, total_checks_failed):
        """
        Sets the total_checks_failed of this TemplateAnalyticsDimensions.
        Indicates how many checks in the template have drifts in the comparison report. This field is only present if isCompliant is false.


        :param total_checks_failed: The total_checks_failed of this TemplateAnalyticsDimensions.
        :type: int
        """
        self._total_checks_failed = total_checks_failed

    @property
    def total_targets(self):
        """
        Gets the total_targets of this TemplateAnalyticsDimensions.
        The number of the target(s) inside the target group for which the template baseline assessment was created for.
        If the isGroup field is false, the value will be 1, representing the single target.


        :return: The total_targets of this TemplateAnalyticsDimensions.
        :rtype: int
        """
        return self._total_targets

    @total_targets.setter
    def total_targets(self, total_targets):
        """
        Sets the total_targets of this TemplateAnalyticsDimensions.
        The number of the target(s) inside the target group for which the template baseline assessment was created for.
        If the isGroup field is false, the value will be 1, representing the single target.


        :param total_targets: The total_targets of this TemplateAnalyticsDimensions.
        :type: int
        """
        self._total_targets = total_targets

    @property
    def total_non_compliant_targets(self):
        """
        Gets the total_non_compliant_targets of this TemplateAnalyticsDimensions.
        The number of the target(s) that have drifts in the comparison report.
        This field is only present if isCompared is true.


        :return: The total_non_compliant_targets of this TemplateAnalyticsDimensions.
        :rtype: int
        """
        return self._total_non_compliant_targets

    @total_non_compliant_targets.setter
    def total_non_compliant_targets(self, total_non_compliant_targets):
        """
        Sets the total_non_compliant_targets of this TemplateAnalyticsDimensions.
        The number of the target(s) that have drifts in the comparison report.
        This field is only present if isCompared is true.


        :param total_non_compliant_targets: The total_non_compliant_targets of this TemplateAnalyticsDimensions.
        :type: int
        """
        self._total_non_compliant_targets = total_non_compliant_targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
