# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StorageMountConfigurationDetails(object):
    """
    The storage mount configuration details
    """

    #: A constant which can be used with the storage_type property of a StorageMountConfigurationDetails.
    #: This constant has a value of "FILE_STORAGE"
    STORAGE_TYPE_FILE_STORAGE = "FILE_STORAGE"

    #: A constant which can be used with the storage_type property of a StorageMountConfigurationDetails.
    #: This constant has a value of "OBJECT_STORAGE"
    STORAGE_TYPE_OBJECT_STORAGE = "OBJECT_STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new StorageMountConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.FileStorageMountConfigurationDetails`
        * :class:`~oci.data_science.models.ObjectStorageMountConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this StorageMountConfigurationDetails.
            Allowed values for this property are: "FILE_STORAGE", "OBJECT_STORAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type storage_type: str

        :param destination_directory_name:
            The value to assign to the destination_directory_name property of this StorageMountConfigurationDetails.
        :type destination_directory_name: str

        :param destination_path:
            The value to assign to the destination_path property of this StorageMountConfigurationDetails.
        :type destination_path: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'destination_directory_name': 'str',
            'destination_path': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType',
            'destination_directory_name': 'destinationDirectoryName',
            'destination_path': 'destinationPath'
        }
        self._storage_type = None
        self._destination_directory_name = None
        self._destination_path = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['storageType']

        if type == 'FILE_STORAGE':
            return 'FileStorageMountConfigurationDetails'

        if type == 'OBJECT_STORAGE':
            return 'ObjectStorageMountConfigurationDetails'
        else:
            return 'StorageMountConfigurationDetails'

    @property
    def storage_type(self):
        """
        **[Required]** Gets the storage_type of this StorageMountConfigurationDetails.
        The type of storage.

        Allowed values for this property are: "FILE_STORAGE", "OBJECT_STORAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The storage_type of this StorageMountConfigurationDetails.
        :rtype: str
        """
        return self._storage_type

    @storage_type.setter
    def storage_type(self, storage_type):
        """
        Sets the storage_type of this StorageMountConfigurationDetails.
        The type of storage.


        :param storage_type: The storage_type of this StorageMountConfigurationDetails.
        :type: str
        """
        allowed_values = ["FILE_STORAGE", "OBJECT_STORAGE"]
        if not value_allowed_none_or_none_sentinel(storage_type, allowed_values):
            storage_type = 'UNKNOWN_ENUM_VALUE'
        self._storage_type = storage_type

    @property
    def destination_directory_name(self):
        """
        **[Required]** Gets the destination_directory_name of this StorageMountConfigurationDetails.
        The local directory name to be mounted


        :return: The destination_directory_name of this StorageMountConfigurationDetails.
        :rtype: str
        """
        return self._destination_directory_name

    @destination_directory_name.setter
    def destination_directory_name(self, destination_directory_name):
        """
        Sets the destination_directory_name of this StorageMountConfigurationDetails.
        The local directory name to be mounted


        :param destination_directory_name: The destination_directory_name of this StorageMountConfigurationDetails.
        :type: str
        """
        self._destination_directory_name = destination_directory_name

    @property
    def destination_path(self):
        """
        Gets the destination_path of this StorageMountConfigurationDetails.
        The local path of the mounted directory, excluding directory name.


        :return: The destination_path of this StorageMountConfigurationDetails.
        :rtype: str
        """
        return self._destination_path

    @destination_path.setter
    def destination_path(self, destination_path):
        """
        Sets the destination_path of this StorageMountConfigurationDetails.
        The local path of the mounted directory, excluding directory name.


        :param destination_path: The destination_path of this StorageMountConfigurationDetails.
        :type: str
        """
        self._destination_path = destination_path

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
