# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbVmClusterStorageDetails(object):
    """
    Storage Details on the Exadata VM cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbVmClusterStorageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_size_in_gbs:
            The value to assign to the total_size_in_gbs property of this ExadbVmClusterStorageDetails.
        :type total_size_in_gbs: int

        """
        self.swagger_types = {
            'total_size_in_gbs': 'int'
        }
        self.attribute_map = {
            'total_size_in_gbs': 'totalSizeInGbs'
        }
        self._total_size_in_gbs = None

    @property
    def total_size_in_gbs(self):
        """
        **[Required]** Gets the total_size_in_gbs of this ExadbVmClusterStorageDetails.
        Total Capacity


        :return: The total_size_in_gbs of this ExadbVmClusterStorageDetails.
        :rtype: int
        """
        return self._total_size_in_gbs

    @total_size_in_gbs.setter
    def total_size_in_gbs(self, total_size_in_gbs):
        """
        Sets the total_size_in_gbs of this ExadbVmClusterStorageDetails.
        Total Capacity


        :param total_size_in_gbs: The total_size_in_gbs of this ExadbVmClusterStorageDetails.
        :type: int
        """
        self._total_size_in_gbs = total_size_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
