# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .discovered_cloud_db_system_component import DiscoveredCloudDbSystemComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DiscoveredCloudCluster(DiscoveredCloudDbSystemComponent):
    """
    The details of a cloud cluster discovered in a cloud DB system discovery run.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DiscoveredCloudCluster object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.DiscoveredCloudCluster.component_type` attribute
        of this class is ``CLUSTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_id:
            The value to assign to the component_id property of this DiscoveredCloudCluster.
        :type component_id: str

        :param display_name:
            The value to assign to the display_name property of this DiscoveredCloudCluster.
        :type display_name: str

        :param component_name:
            The value to assign to the component_name property of this DiscoveredCloudCluster.
        :type component_name: str

        :param component_type:
            The value to assign to the component_type property of this DiscoveredCloudCluster.
            Allowed values for this property are: "ASM", "ASM_INSTANCE", "CLUSTER", "CLUSTER_INSTANCE", "DATABASE", "DATABASE_INSTANCE", "DATABASE_HOME", "DATABASE_NODE", "DBSYSTEM", "LISTENER", "PLUGGABLE_DATABASE"
        :type component_type: str

        :param resource_id:
            The value to assign to the resource_id property of this DiscoveredCloudCluster.
        :type resource_id: str

        :param dbaas_id:
            The value to assign to the dbaas_id property of this DiscoveredCloudCluster.
        :type dbaas_id: str

        :param is_selected_for_monitoring:
            The value to assign to the is_selected_for_monitoring property of this DiscoveredCloudCluster.
        :type is_selected_for_monitoring: bool

        :param status:
            The value to assign to the status property of this DiscoveredCloudCluster.
            Allowed values for this property are: "NEW", "EXISTING", "EXISTING_BASIC", "EXISTING_PE", "EXISTING_BASIC_PE", "MARKED_FOR_UPGRADE", "MARKED_FOR_MIGRATION", "MARKED_FOR_UPGRADE_MIGRATION", "MARKED_FOR_DELETION", "UNKNOWN"
        :type status: str

        :param associated_components:
            The value to assign to the associated_components property of this DiscoveredCloudCluster.
        :type associated_components: list[oci.database_management.models.AssociatedCloudComponent]

        :param grid_home:
            The value to assign to the grid_home property of this DiscoveredCloudCluster.
        :type grid_home: str

        :param version:
            The value to assign to the version property of this DiscoveredCloudCluster.
        :type version: str

        :param is_flex_cluster:
            The value to assign to the is_flex_cluster property of this DiscoveredCloudCluster.
        :type is_flex_cluster: bool

        :param network_configurations:
            The value to assign to the network_configurations property of this DiscoveredCloudCluster.
        :type network_configurations: list[oci.database_management.models.CloudClusterNetworkConfiguration]

        :param vip_configurations:
            The value to assign to the vip_configurations property of this DiscoveredCloudCluster.
        :type vip_configurations: list[oci.database_management.models.CloudClusterVipConfiguration]

        :param scan_configurations:
            The value to assign to the scan_configurations property of this DiscoveredCloudCluster.
        :type scan_configurations: list[oci.database_management.models.CloudClusterScanListenerConfiguration]

        :param ocr_file_location:
            The value to assign to the ocr_file_location property of this DiscoveredCloudCluster.
        :type ocr_file_location: str

        :param cluster_instances:
            The value to assign to the cluster_instances property of this DiscoveredCloudCluster.
        :type cluster_instances: list[oci.database_management.models.DiscoveredCloudClusterInstance]

        """
        self.swagger_types = {
            'component_id': 'str',
            'display_name': 'str',
            'component_name': 'str',
            'component_type': 'str',
            'resource_id': 'str',
            'dbaas_id': 'str',
            'is_selected_for_monitoring': 'bool',
            'status': 'str',
            'associated_components': 'list[AssociatedCloudComponent]',
            'grid_home': 'str',
            'version': 'str',
            'is_flex_cluster': 'bool',
            'network_configurations': 'list[CloudClusterNetworkConfiguration]',
            'vip_configurations': 'list[CloudClusterVipConfiguration]',
            'scan_configurations': 'list[CloudClusterScanListenerConfiguration]',
            'ocr_file_location': 'str',
            'cluster_instances': 'list[DiscoveredCloudClusterInstance]'
        }
        self.attribute_map = {
            'component_id': 'componentId',
            'display_name': 'displayName',
            'component_name': 'componentName',
            'component_type': 'componentType',
            'resource_id': 'resourceId',
            'dbaas_id': 'dbaasId',
            'is_selected_for_monitoring': 'isSelectedForMonitoring',
            'status': 'status',
            'associated_components': 'associatedComponents',
            'grid_home': 'gridHome',
            'version': 'version',
            'is_flex_cluster': 'isFlexCluster',
            'network_configurations': 'networkConfigurations',
            'vip_configurations': 'vipConfigurations',
            'scan_configurations': 'scanConfigurations',
            'ocr_file_location': 'ocrFileLocation',
            'cluster_instances': 'clusterInstances'
        }
        self._component_id = None
        self._display_name = None
        self._component_name = None
        self._component_type = None
        self._resource_id = None
        self._dbaas_id = None
        self._is_selected_for_monitoring = None
        self._status = None
        self._associated_components = None
        self._grid_home = None
        self._version = None
        self._is_flex_cluster = None
        self._network_configurations = None
        self._vip_configurations = None
        self._scan_configurations = None
        self._ocr_file_location = None
        self._cluster_instances = None
        self._component_type = 'CLUSTER'

    @property
    def grid_home(self):
        """
        Gets the grid_home of this DiscoveredCloudCluster.
        The directory in which Oracle Grid Infrastructure is installed.


        :return: The grid_home of this DiscoveredCloudCluster.
        :rtype: str
        """
        return self._grid_home

    @grid_home.setter
    def grid_home(self, grid_home):
        """
        Sets the grid_home of this DiscoveredCloudCluster.
        The directory in which Oracle Grid Infrastructure is installed.


        :param grid_home: The grid_home of this DiscoveredCloudCluster.
        :type: str
        """
        self._grid_home = grid_home

    @property
    def version(self):
        """
        Gets the version of this DiscoveredCloudCluster.
        The version of Oracle Clusterware running in the cluster.


        :return: The version of this DiscoveredCloudCluster.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this DiscoveredCloudCluster.
        The version of Oracle Clusterware running in the cluster.


        :param version: The version of this DiscoveredCloudCluster.
        :type: str
        """
        self._version = version

    @property
    def is_flex_cluster(self):
        """
        Gets the is_flex_cluster of this DiscoveredCloudCluster.
        Indicates whether the cluster is an Oracle Flex Cluster or not.


        :return: The is_flex_cluster of this DiscoveredCloudCluster.
        :rtype: bool
        """
        return self._is_flex_cluster

    @is_flex_cluster.setter
    def is_flex_cluster(self, is_flex_cluster):
        """
        Sets the is_flex_cluster of this DiscoveredCloudCluster.
        Indicates whether the cluster is an Oracle Flex Cluster or not.


        :param is_flex_cluster: The is_flex_cluster of this DiscoveredCloudCluster.
        :type: bool
        """
        self._is_flex_cluster = is_flex_cluster

    @property
    def network_configurations(self):
        """
        Gets the network_configurations of this DiscoveredCloudCluster.
        The list of network address configurations of the cloud cluster.


        :return: The network_configurations of this DiscoveredCloudCluster.
        :rtype: list[oci.database_management.models.CloudClusterNetworkConfiguration]
        """
        return self._network_configurations

    @network_configurations.setter
    def network_configurations(self, network_configurations):
        """
        Sets the network_configurations of this DiscoveredCloudCluster.
        The list of network address configurations of the cloud cluster.


        :param network_configurations: The network_configurations of this DiscoveredCloudCluster.
        :type: list[oci.database_management.models.CloudClusterNetworkConfiguration]
        """
        self._network_configurations = network_configurations

    @property
    def vip_configurations(self):
        """
        Gets the vip_configurations of this DiscoveredCloudCluster.
        The list of Virtual IP (VIP) configurations of the cloud cluster.


        :return: The vip_configurations of this DiscoveredCloudCluster.
        :rtype: list[oci.database_management.models.CloudClusterVipConfiguration]
        """
        return self._vip_configurations

    @vip_configurations.setter
    def vip_configurations(self, vip_configurations):
        """
        Sets the vip_configurations of this DiscoveredCloudCluster.
        The list of Virtual IP (VIP) configurations of the cloud cluster.


        :param vip_configurations: The vip_configurations of this DiscoveredCloudCluster.
        :type: list[oci.database_management.models.CloudClusterVipConfiguration]
        """
        self._vip_configurations = vip_configurations

    @property
    def scan_configurations(self):
        """
        Gets the scan_configurations of this DiscoveredCloudCluster.
        The list of Single Client Access Name (SCAN) configurations of the cloud cluster.


        :return: The scan_configurations of this DiscoveredCloudCluster.
        :rtype: list[oci.database_management.models.CloudClusterScanListenerConfiguration]
        """
        return self._scan_configurations

    @scan_configurations.setter
    def scan_configurations(self, scan_configurations):
        """
        Sets the scan_configurations of this DiscoveredCloudCluster.
        The list of Single Client Access Name (SCAN) configurations of the cloud cluster.


        :param scan_configurations: The scan_configurations of this DiscoveredCloudCluster.
        :type: list[oci.database_management.models.CloudClusterScanListenerConfiguration]
        """
        self._scan_configurations = scan_configurations

    @property
    def ocr_file_location(self):
        """
        Gets the ocr_file_location of this DiscoveredCloudCluster.
        The location of the Oracle Cluster Registry (OCR) file.


        :return: The ocr_file_location of this DiscoveredCloudCluster.
        :rtype: str
        """
        return self._ocr_file_location

    @ocr_file_location.setter
    def ocr_file_location(self, ocr_file_location):
        """
        Sets the ocr_file_location of this DiscoveredCloudCluster.
        The location of the Oracle Cluster Registry (OCR) file.


        :param ocr_file_location: The ocr_file_location of this DiscoveredCloudCluster.
        :type: str
        """
        self._ocr_file_location = ocr_file_location

    @property
    def cluster_instances(self):
        """
        Gets the cluster_instances of this DiscoveredCloudCluster.
        The list of cluster instances for the cloud cluster.


        :return: The cluster_instances of this DiscoveredCloudCluster.
        :rtype: list[oci.database_management.models.DiscoveredCloudClusterInstance]
        """
        return self._cluster_instances

    @cluster_instances.setter
    def cluster_instances(self, cluster_instances):
        """
        Sets the cluster_instances of this DiscoveredCloudCluster.
        The list of cluster instances for the cloud cluster.


        :param cluster_instances: The cluster_instances of this DiscoveredCloudCluster.
        :type: list[oci.database_management.models.DiscoveredCloudClusterInstance]
        """
        self._cluster_instances = cluster_instances

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
