# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImageDetails(object):
    """
    Image details containing the subscribed image, its status, version, owner and time of creation.
    """

    #: A constant which can be used with the image_status property of a ImageDetails.
    #: This constant has a value of "GREEN"
    IMAGE_STATUS_GREEN = "GREEN"

    #: A constant which can be used with the image_status property of a ImageDetails.
    #: This constant has a value of "YELLOW"
    IMAGE_STATUS_YELLOW = "YELLOW"

    #: A constant which can be used with the image_status property of a ImageDetails.
    #: This constant has a value of "RED"
    IMAGE_STATUS_RED = "RED"

    def __init__(self, **kwargs):
        """
        Initializes a new ImageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param image_id:
            The value to assign to the image_id property of this ImageDetails.
        :type image_id: str

        :param subscribed_image:
            The value to assign to the subscribed_image property of this ImageDetails.
        :type subscribed_image: str

        :param current_version:
            The value to assign to the current_version property of this ImageDetails.
        :type current_version: str

        :param image_status:
            The value to assign to the image_status property of this ImageDetails.
            Allowed values for this property are: "GREEN", "YELLOW", "RED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type image_status: str

        :param image_version:
            The value to assign to the image_version property of this ImageDetails.
        :type image_version: str

        :param image_owner:
            The value to assign to the image_owner property of this ImageDetails.
        :type image_owner: str

        :param created_by:
            The value to assign to the created_by property of this ImageDetails.
        :type created_by: str

        :param time_image_creation:
            The value to assign to the time_image_creation property of this ImageDetails.
        :type time_image_creation: datetime

        :param up_to_date_image_version:
            The value to assign to the up_to_date_image_version property of this ImageDetails.
        :type up_to_date_image_version: str

        """
        self.swagger_types = {
            'image_id': 'str',
            'subscribed_image': 'str',
            'current_version': 'str',
            'image_status': 'str',
            'image_version': 'str',
            'image_owner': 'str',
            'created_by': 'str',
            'time_image_creation': 'datetime',
            'up_to_date_image_version': 'str'
        }
        self.attribute_map = {
            'image_id': 'imageId',
            'subscribed_image': 'subscribedImage',
            'current_version': 'currentVersion',
            'image_status': 'imageStatus',
            'image_version': 'imageVersion',
            'image_owner': 'imageOwner',
            'created_by': 'createdBy',
            'time_image_creation': 'timeImageCreation',
            'up_to_date_image_version': 'upToDateImageVersion'
        }
        self._image_id = None
        self._subscribed_image = None
        self._current_version = None
        self._image_status = None
        self._image_version = None
        self._image_owner = None
        self._created_by = None
        self._time_image_creation = None
        self._up_to_date_image_version = None

    @property
    def image_id(self):
        """
        Gets the image_id of this ImageDetails.
        Image identifier.


        :return: The image_id of this ImageDetails.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this ImageDetails.
        Image identifier.


        :param image_id: The image_id of this ImageDetails.
        :type: str
        """
        self._image_id = image_id

    @property
    def subscribed_image(self):
        """
        Gets the subscribed_image of this ImageDetails.
        Subscribed image.


        :return: The subscribed_image of this ImageDetails.
        :rtype: str
        """
        return self._subscribed_image

    @subscribed_image.setter
    def subscribed_image(self, subscribed_image):
        """
        Sets the subscribed_image of this ImageDetails.
        Subscribed image.


        :param subscribed_image: The subscribed_image of this ImageDetails.
        :type: str
        """
        self._subscribed_image = subscribed_image

    @property
    def current_version(self):
        """
        Gets the current_version of this ImageDetails.
        Name of the image version marked as current of the image.


        :return: The current_version of this ImageDetails.
        :rtype: str
        """
        return self._current_version

    @current_version.setter
    def current_version(self, current_version):
        """
        Sets the current_version of this ImageDetails.
        Name of the image version marked as current of the image.


        :param current_version: The current_version of this ImageDetails.
        :type: str
        """
        self._current_version = current_version

    @property
    def image_status(self):
        """
        Gets the image_status of this ImageDetails.
        Image status.

        Allowed values for this property are: "GREEN", "YELLOW", "RED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The image_status of this ImageDetails.
        :rtype: str
        """
        return self._image_status

    @image_status.setter
    def image_status(self, image_status):
        """
        Sets the image_status of this ImageDetails.
        Image status.


        :param image_status: The image_status of this ImageDetails.
        :type: str
        """
        allowed_values = ["GREEN", "YELLOW", "RED"]
        if not value_allowed_none_or_none_sentinel(image_status, allowed_values):
            image_status = 'UNKNOWN_ENUM_VALUE'
        self._image_status = image_status

    @property
    def image_version(self):
        """
        Gets the image_version of this ImageDetails.
        Release version of the image.


        :return: The image_version of this ImageDetails.
        :rtype: str
        """
        return self._image_version

    @image_version.setter
    def image_version(self, image_version):
        """
        Sets the image_version of this ImageDetails.
        Release version of the image.


        :param image_version: The image_version of this ImageDetails.
        :type: str
        """
        self._image_version = image_version

    @property
    def image_owner(self):
        """
        Gets the image_owner of this ImageDetails.
        Owner of the image.


        :return: The image_owner of this ImageDetails.
        :rtype: str
        """
        return self._image_owner

    @image_owner.setter
    def image_owner(self, image_owner):
        """
        Sets the image_owner of this ImageDetails.
        Owner of the image.


        :param image_owner: The image_owner of this ImageDetails.
        :type: str
        """
        self._image_owner = image_owner

    @property
    def created_by(self):
        """
        Gets the created_by of this ImageDetails.
        Name of the person who created the image.


        :return: The created_by of this ImageDetails.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this ImageDetails.
        Name of the person who created the image.


        :param created_by: The created_by of this ImageDetails.
        :type: str
        """
        self._created_by = created_by

    @property
    def time_image_creation(self):
        """
        Gets the time_image_creation of this ImageDetails.
        Date when the image was created.


        :return: The time_image_creation of this ImageDetails.
        :rtype: datetime
        """
        return self._time_image_creation

    @time_image_creation.setter
    def time_image_creation(self, time_image_creation):
        """
        Sets the time_image_creation of this ImageDetails.
        Date when the image was created.


        :param time_image_creation: The time_image_creation of this ImageDetails.
        :type: datetime
        """
        self._time_image_creation = time_image_creation

    @property
    def up_to_date_image_version(self):
        """
        Gets the up_to_date_image_version of this ImageDetails.
        An image version name, that is up to date and has no recommendations.


        :return: The up_to_date_image_version of this ImageDetails.
        :rtype: str
        """
        return self._up_to_date_image_version

    @up_to_date_image_version.setter
    def up_to_date_image_version(self, up_to_date_image_version):
        """
        Sets the up_to_date_image_version of this ImageDetails.
        An image version name, that is up to date and has no recommendations.


        :param up_to_date_image_version: The up_to_date_image_version of this ImageDetails.
        :type: str
        """
        self._up_to_date_image_version = up_to_date_image_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
