# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDelegationControlDetails(object):
    """
    Information about the new Delegation Control.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDelegationControlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateDelegationControlDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateDelegationControlDetails.
        :type description: str

        :param num_approvals_required:
            The value to assign to the num_approvals_required property of this UpdateDelegationControlDetails.
        :type num_approvals_required: int

        :param delegation_subscription_ids:
            The value to assign to the delegation_subscription_ids property of this UpdateDelegationControlDetails.
        :type delegation_subscription_ids: list[str]

        :param is_auto_approve_during_maintenance:
            The value to assign to the is_auto_approve_during_maintenance property of this UpdateDelegationControlDetails.
        :type is_auto_approve_during_maintenance: bool

        :param resource_ids:
            The value to assign to the resource_ids property of this UpdateDelegationControlDetails.
        :type resource_ids: list[str]

        :param pre_approved_service_provider_action_names:
            The value to assign to the pre_approved_service_provider_action_names property of this UpdateDelegationControlDetails.
        :type pre_approved_service_provider_action_names: list[str]

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this UpdateDelegationControlDetails.
        :type notification_topic_id: str

        :param notification_message_format:
            The value to assign to the notification_message_format property of this UpdateDelegationControlDetails.
        :type notification_message_format: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateDelegationControlDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateDelegationControlDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'num_approvals_required': 'int',
            'delegation_subscription_ids': 'list[str]',
            'is_auto_approve_during_maintenance': 'bool',
            'resource_ids': 'list[str]',
            'pre_approved_service_provider_action_names': 'list[str]',
            'notification_topic_id': 'str',
            'notification_message_format': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'num_approvals_required': 'numApprovalsRequired',
            'delegation_subscription_ids': 'delegationSubscriptionIds',
            'is_auto_approve_during_maintenance': 'isAutoApproveDuringMaintenance',
            'resource_ids': 'resourceIds',
            'pre_approved_service_provider_action_names': 'preApprovedServiceProviderActionNames',
            'notification_topic_id': 'notificationTopicId',
            'notification_message_format': 'notificationMessageFormat',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._num_approvals_required = None
        self._delegation_subscription_ids = None
        self._is_auto_approve_during_maintenance = None
        self._resource_ids = None
        self._pre_approved_service_provider_action_names = None
        self._notification_topic_id = None
        self._notification_message_format = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateDelegationControlDetails.
        Name of the Delegation Control. The name does not need to be unique.


        :return: The display_name of this UpdateDelegationControlDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateDelegationControlDetails.
        Name of the Delegation Control. The name does not need to be unique.


        :param display_name: The display_name of this UpdateDelegationControlDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateDelegationControlDetails.
        Description of the Delegation Control.


        :return: The description of this UpdateDelegationControlDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateDelegationControlDetails.
        Description of the Delegation Control.


        :param description: The description of this UpdateDelegationControlDetails.
        :type: str
        """
        self._description = description

    @property
    def num_approvals_required(self):
        """
        Gets the num_approvals_required of this UpdateDelegationControlDetails.
        number of approvals required.


        :return: The num_approvals_required of this UpdateDelegationControlDetails.
        :rtype: int
        """
        return self._num_approvals_required

    @num_approvals_required.setter
    def num_approvals_required(self, num_approvals_required):
        """
        Sets the num_approvals_required of this UpdateDelegationControlDetails.
        number of approvals required.


        :param num_approvals_required: The num_approvals_required of this UpdateDelegationControlDetails.
        :type: int
        """
        self._num_approvals_required = num_approvals_required

    @property
    def delegation_subscription_ids(self):
        """
        Gets the delegation_subscription_ids of this UpdateDelegationControlDetails.
        List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.


        :return: The delegation_subscription_ids of this UpdateDelegationControlDetails.
        :rtype: list[str]
        """
        return self._delegation_subscription_ids

    @delegation_subscription_ids.setter
    def delegation_subscription_ids(self, delegation_subscription_ids):
        """
        Sets the delegation_subscription_ids of this UpdateDelegationControlDetails.
        List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.


        :param delegation_subscription_ids: The delegation_subscription_ids of this UpdateDelegationControlDetails.
        :type: list[str]
        """
        self._delegation_subscription_ids = delegation_subscription_ids

    @property
    def is_auto_approve_during_maintenance(self):
        """
        Gets the is_auto_approve_during_maintenance of this UpdateDelegationControlDetails.
        Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.


        :return: The is_auto_approve_during_maintenance of this UpdateDelegationControlDetails.
        :rtype: bool
        """
        return self._is_auto_approve_during_maintenance

    @is_auto_approve_during_maintenance.setter
    def is_auto_approve_during_maintenance(self, is_auto_approve_during_maintenance):
        """
        Sets the is_auto_approve_during_maintenance of this UpdateDelegationControlDetails.
        Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.


        :param is_auto_approve_during_maintenance: The is_auto_approve_during_maintenance of this UpdateDelegationControlDetails.
        :type: bool
        """
        self._is_auto_approve_during_maintenance = is_auto_approve_during_maintenance

    @property
    def resource_ids(self):
        """
        Gets the resource_ids of this UpdateDelegationControlDetails.
        The OCID of the selected resources that this Delegation Control is applicable to.


        :return: The resource_ids of this UpdateDelegationControlDetails.
        :rtype: list[str]
        """
        return self._resource_ids

    @resource_ids.setter
    def resource_ids(self, resource_ids):
        """
        Sets the resource_ids of this UpdateDelegationControlDetails.
        The OCID of the selected resources that this Delegation Control is applicable to.


        :param resource_ids: The resource_ids of this UpdateDelegationControlDetails.
        :type: list[str]
        """
        self._resource_ids = resource_ids

    @property
    def pre_approved_service_provider_action_names(self):
        """
        Gets the pre_approved_service_provider_action_names of this UpdateDelegationControlDetails.
        List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be
        automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.


        :return: The pre_approved_service_provider_action_names of this UpdateDelegationControlDetails.
        :rtype: list[str]
        """
        return self._pre_approved_service_provider_action_names

    @pre_approved_service_provider_action_names.setter
    def pre_approved_service_provider_action_names(self, pre_approved_service_provider_action_names):
        """
        Sets the pre_approved_service_provider_action_names of this UpdateDelegationControlDetails.
        List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be
        automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.


        :param pre_approved_service_provider_action_names: The pre_approved_service_provider_action_names of this UpdateDelegationControlDetails.
        :type: list[str]
        """
        self._pre_approved_service_provider_action_names = pre_approved_service_provider_action_names

    @property
    def notification_topic_id(self):
        """
        Gets the notification_topic_id of this UpdateDelegationControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :return: The notification_topic_id of this UpdateDelegationControlDetails.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this UpdateDelegationControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :param notification_topic_id: The notification_topic_id of this UpdateDelegationControlDetails.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def notification_message_format(self):
        """
        Gets the notification_message_format of this UpdateDelegationControlDetails.
        The format of the OCI Notification messages for this Delegation Control.


        :return: The notification_message_format of this UpdateDelegationControlDetails.
        :rtype: str
        """
        return self._notification_message_format

    @notification_message_format.setter
    def notification_message_format(self, notification_message_format):
        """
        Sets the notification_message_format of this UpdateDelegationControlDetails.
        The format of the OCI Notification messages for this Delegation Control.


        :param notification_message_format: The notification_message_format of this UpdateDelegationControlDetails.
        :type: str
        """
        self._notification_message_format = notification_message_format

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateDelegationControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateDelegationControlDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateDelegationControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateDelegationControlDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateDelegationControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateDelegationControlDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateDelegationControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateDelegationControlDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
