# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MergeChecks(object):
    """
    Criteria which must be satisfied to merge a pull request.
    """

    #: A constant which can be used with the last_build_succeeded property of a MergeChecks.
    #: This constant has a value of "ENABLED"
    LAST_BUILD_SUCCEEDED_ENABLED = "ENABLED"

    #: A constant which can be used with the last_build_succeeded property of a MergeChecks.
    #: This constant has a value of "DISABLED"
    LAST_BUILD_SUCCEEDED_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new MergeChecks object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param last_build_succeeded:
            The value to assign to the last_build_succeeded property of this MergeChecks.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type last_build_succeeded: str

        """
        self.swagger_types = {
            'last_build_succeeded': 'str'
        }
        self.attribute_map = {
            'last_build_succeeded': 'lastBuildSucceeded'
        }
        self._last_build_succeeded = None

    @property
    def last_build_succeeded(self):
        """
        **[Required]** Gets the last_build_succeeded of this MergeChecks.
        Indicates whether or not a pull request must have a successful build run and no queued builds before it can be merged

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The last_build_succeeded of this MergeChecks.
        :rtype: str
        """
        return self._last_build_succeeded

    @last_build_succeeded.setter
    def last_build_succeeded(self, last_build_succeeded):
        """
        Sets the last_build_succeeded of this MergeChecks.
        Indicates whether or not a pull request must have a successful build run and no queued builds before it can be merged


        :param last_build_succeeded: The last_build_succeeded of this MergeChecks.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(last_build_succeeded, allowed_values):
            last_build_succeeded = 'UNKNOWN_ENUM_VALUE'
        self._last_build_succeeded = last_build_succeeded

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
