# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutomaticDrConfigurationMember(object):
    """
    Details of a member in an Automatic DR configuration.
    """

    #: A constant which can be used with the member_type property of a AutomaticDrConfigurationMember.
    #: This constant has a value of "DATABASE"
    MEMBER_TYPE_DATABASE = "DATABASE"

    #: A constant which can be used with the member_type property of a AutomaticDrConfigurationMember.
    #: This constant has a value of "AUTONOMOUS_DATABASE"
    MEMBER_TYPE_AUTONOMOUS_DATABASE = "AUTONOMOUS_DATABASE"

    #: A constant which can be used with the member_type property of a AutomaticDrConfigurationMember.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE"
    MEMBER_TYPE_AUTONOMOUS_CONTAINER_DATABASE = "AUTONOMOUS_CONTAINER_DATABASE"

    def __init__(self, **kwargs):
        """
        Initializes a new AutomaticDrConfigurationMember object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.disaster_recovery.models.AutomaticDrConfigurationMemberAutonomousDatabase`
        * :class:`~oci.disaster_recovery.models.AutomaticDrConfigurationMemberDatabase`
        * :class:`~oci.disaster_recovery.models.AutomaticDrConfigurationMemberAutonomousContainerDatabase`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this AutomaticDrConfigurationMember.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this AutomaticDrConfigurationMember.
            Allowed values for this property are: "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type member_type: str

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str'
        }
        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType'
        }
        self._member_id = None
        self._member_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['memberType']

        if type == 'AUTONOMOUS_DATABASE':
            return 'AutomaticDrConfigurationMemberAutonomousDatabase'

        if type == 'DATABASE':
            return 'AutomaticDrConfigurationMemberDatabase'

        if type == 'AUTONOMOUS_CONTAINER_DATABASE':
            return 'AutomaticDrConfigurationMemberAutonomousContainerDatabase'
        else:
            return 'AutomaticDrConfigurationMember'

    @property
    def member_id(self):
        """
        **[Required]** Gets the member_id of this AutomaticDrConfigurationMember.
        The unique id of the member. Must not be modified by user.

        Example: `ocid1.database.oc1..uniqueID`


        :return: The member_id of this AutomaticDrConfigurationMember.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this AutomaticDrConfigurationMember.
        The unique id of the member. Must not be modified by user.

        Example: `ocid1.database.oc1..uniqueID`


        :param member_id: The member_id of this AutomaticDrConfigurationMember.
        :type: str
        """
        self._member_id = member_id

    @property
    def member_type(self):
        """
        **[Required]** Gets the member_type of this AutomaticDrConfigurationMember.
        The type of the member.

        Allowed values for this property are: "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The member_type of this AutomaticDrConfigurationMember.
        :rtype: str
        """
        return self._member_type

    @member_type.setter
    def member_type(self, member_type):
        """
        Sets the member_type of this AutomaticDrConfigurationMember.
        The type of the member.


        :param member_type: The member_type of this AutomaticDrConfigurationMember.
        :type: str
        """
        allowed_values = ["DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE"]
        if not value_allowed_none_or_none_sentinel(member_type, allowed_values):
            member_type = 'UNKNOWN_ENUM_VALUE'
        self._member_type = member_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
