# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOkeClusterVaultMappingDetails(object):
    """
    Update source-to-destination mapping for a vault.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOkeClusterVaultMappingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_vault_id:
            The value to assign to the source_vault_id property of this UpdateOkeClusterVaultMappingDetails.
        :type source_vault_id: str

        :param destination_vault_id:
            The value to assign to the destination_vault_id property of this UpdateOkeClusterVaultMappingDetails.
        :type destination_vault_id: str

        """
        self.swagger_types = {
            'source_vault_id': 'str',
            'destination_vault_id': 'str'
        }
        self.attribute_map = {
            'source_vault_id': 'sourceVaultId',
            'destination_vault_id': 'destinationVaultId'
        }
        self._source_vault_id = None
        self._destination_vault_id = None

    @property
    def source_vault_id(self):
        """
        **[Required]** Gets the source_vault_id of this UpdateOkeClusterVaultMappingDetails.
        The OCID of the source Vault.

         Example: `ocid1.vault.oc1..uniqueID`


        :return: The source_vault_id of this UpdateOkeClusterVaultMappingDetails.
        :rtype: str
        """
        return self._source_vault_id

    @source_vault_id.setter
    def source_vault_id(self, source_vault_id):
        """
        Sets the source_vault_id of this UpdateOkeClusterVaultMappingDetails.
        The OCID of the source Vault.

         Example: `ocid1.vault.oc1..uniqueID`


        :param source_vault_id: The source_vault_id of this UpdateOkeClusterVaultMappingDetails.
        :type: str
        """
        self._source_vault_id = source_vault_id

    @property
    def destination_vault_id(self):
        """
        **[Required]** Gets the destination_vault_id of this UpdateOkeClusterVaultMappingDetails.
        The OCID of the destination Vault.

        Example: `ocid1.vault.oc1..uniqueID`


        :return: The destination_vault_id of this UpdateOkeClusterVaultMappingDetails.
        :rtype: str
        """
        return self._destination_vault_id

    @destination_vault_id.setter
    def destination_vault_id(self, destination_vault_id):
        """
        Sets the destination_vault_id of this UpdateOkeClusterVaultMappingDetails.
        The OCID of the destination Vault.

        Example: `ocid1.vault.oc1..uniqueID`


        :param destination_vault_id: The destination_vault_id of this UpdateOkeClusterVaultMappingDetails.
        :type: str
        """
        self._destination_vault_id = destination_vault_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
