# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigCategoryDetails(object):
    """
    Config Category Details.
    """

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "PRODUCT"
    CONFIG_CATEGORY_PRODUCT = "PRODUCT"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "PRODUCT_STACK"
    CONFIG_CATEGORY_PRODUCT_STACK = "PRODUCT_STACK"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "ENVIRONMENT"
    CONFIG_CATEGORY_ENVIRONMENT = "ENVIRONMENT"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "PATCH_TYPE"
    CONFIG_CATEGORY_PATCH_TYPE = "PATCH_TYPE"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "CREDENTIAL"
    CONFIG_CATEGORY_CREDENTIAL = "CREDENTIAL"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "SELF_HOSTED_INSTANCE"
    CONFIG_CATEGORY_SELF_HOSTED_INSTANCE = "SELF_HOSTED_INSTANCE"

    #: A constant which can be used with the config_category property of a ConfigCategoryDetails.
    #: This constant has a value of "LIFECYCLE_OPERATION"
    CONFIG_CATEGORY_LIFECYCLE_OPERATION = "LIFECYCLE_OPERATION"

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigCategoryDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.ProductStackConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.EnvironmentConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.CredentialConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.PatchTypeConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.LifecycleOperationConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.ProductConfigCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.SelfHostedInstanceConfigCategoryDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_category:
            The value to assign to the config_category property of this ConfigCategoryDetails.
            Allowed values for this property are: "PRODUCT", "PRODUCT_STACK", "ENVIRONMENT", "PATCH_TYPE", "CREDENTIAL", "SELF_HOSTED_INSTANCE", "LIFECYCLE_OPERATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_category: str

        """
        self.swagger_types = {
            'config_category': 'str'
        }
        self.attribute_map = {
            'config_category': 'configCategory'
        }
        self._config_category = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['configCategory']

        if type == 'PRODUCT_STACK':
            return 'ProductStackConfigCategoryDetails'

        if type == 'ENVIRONMENT':
            return 'EnvironmentConfigCategoryDetails'

        if type == 'CREDENTIAL':
            return 'CredentialConfigCategoryDetails'

        if type == 'PATCH_TYPE':
            return 'PatchTypeConfigCategoryDetails'

        if type == 'LIFECYCLE_OPERATION':
            return 'LifecycleOperationConfigCategoryDetails'

        if type == 'PRODUCT':
            return 'ProductConfigCategoryDetails'

        if type == 'SELF_HOSTED_INSTANCE':
            return 'SelfHostedInstanceConfigCategoryDetails'
        else:
            return 'ConfigCategoryDetails'

    @property
    def config_category(self):
        """
        **[Required]** Gets the config_category of this ConfigCategoryDetails.
        Category of configuration

        Allowed values for this property are: "PRODUCT", "PRODUCT_STACK", "ENVIRONMENT", "PATCH_TYPE", "CREDENTIAL", "SELF_HOSTED_INSTANCE", "LIFECYCLE_OPERATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The config_category of this ConfigCategoryDetails.
        :rtype: str
        """
        return self._config_category

    @config_category.setter
    def config_category(self, config_category):
        """
        Sets the config_category of this ConfigCategoryDetails.
        Category of configuration


        :param config_category: The config_category of this ConfigCategoryDetails.
        :type: str
        """
        allowed_values = ["PRODUCT", "PRODUCT_STACK", "ENVIRONMENT", "PATCH_TYPE", "CREDENTIAL", "SELF_HOSTED_INSTANCE", "LIFECYCLE_OPERATION"]
        if not value_allowed_none_or_none_sentinel(config_category, allowed_values):
            config_category = 'UNKNOWN_ENUM_VALUE'
        self._config_category = config_category

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
