# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_fsu_cycle_details import CreateFsuCycleDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateUpgradeFsuCycle(CreateFsuCycleDetails):
    """
    Upgrade Exadata Fleet Update Cycle resource creation details. Batching strategy should always be NON_ROLLING for DB collection upgrade.
    For GI upgrade case, Batching strategy may be NON_ROLLING or SEQUENTIAL(default).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateUpgradeFsuCycle object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateUpgradeFsuCycle.type` attribute
        of this class is ``UPGRADE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateUpgradeFsuCycle.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateUpgradeFsuCycle.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this CreateUpgradeFsuCycle.
            Allowed values for this property are: "PATCH", "UPGRADE"
        :type type: str

        :param fsu_collection_id:
            The value to assign to the fsu_collection_id property of this CreateUpgradeFsuCycle.
        :type fsu_collection_id: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this CreateUpgradeFsuCycle.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this CreateUpgradeFsuCycle.
        :type batching_strategy: oci.fleet_software_update.models.CreateBatchingStrategyDetails

        :param stage_action_schedule:
            The value to assign to the stage_action_schedule property of this CreateUpgradeFsuCycle.
        :type stage_action_schedule: oci.fleet_software_update.models.CreateScheduleDetails

        :param apply_action_schedule:
            The value to assign to the apply_action_schedule property of this CreateUpgradeFsuCycle.
        :type apply_action_schedule: oci.fleet_software_update.models.CreateScheduleDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this CreateUpgradeFsuCycle.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateUpgradeFsuCycle.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateUpgradeFsuCycle.
        :type defined_tags: dict(str, dict(str, object))

        :param upgrade_details:
            The value to assign to the upgrade_details property of this CreateUpgradeFsuCycle.
        :type upgrade_details: oci.fleet_software_update.models.UpgradeDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'fsu_collection_id': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'CreateBatchingStrategyDetails',
            'stage_action_schedule': 'CreateScheduleDetails',
            'apply_action_schedule': 'CreateScheduleDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'upgrade_details': 'UpgradeDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'fsu_collection_id': 'fsuCollectionId',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'stage_action_schedule': 'stageActionSchedule',
            'apply_action_schedule': 'applyActionSchedule',
            'diagnostics_collection': 'diagnosticsCollection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'upgrade_details': 'upgradeDetails'
        }
        self._display_name = None
        self._compartment_id = None
        self._type = None
        self._fsu_collection_id = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._stage_action_schedule = None
        self._apply_action_schedule = None
        self._diagnostics_collection = None
        self._freeform_tags = None
        self._defined_tags = None
        self._upgrade_details = None
        self._type = 'UPGRADE'

    @property
    def upgrade_details(self):
        """
        Gets the upgrade_details of this CreateUpgradeFsuCycle.

        :return: The upgrade_details of this CreateUpgradeFsuCycle.
        :rtype: oci.fleet_software_update.models.UpgradeDetails
        """
        return self._upgrade_details

    @upgrade_details.setter
    def upgrade_details(self, upgrade_details):
        """
        Sets the upgrade_details of this CreateUpgradeFsuCycle.

        :param upgrade_details: The upgrade_details of this CreateUpgradeFsuCycle.
        :type: oci.fleet_software_update.models.UpgradeDetails
        """
        self._upgrade_details = upgrade_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
