# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FsuCollectionSummary(object):
    """
    Exadata Fleet Update Collection Resource.
    """

    #: A constant which can be used with the type property of a FsuCollectionSummary.
    #: This constant has a value of "DB"
    TYPE_DB = "DB"

    #: A constant which can be used with the type property of a FsuCollectionSummary.
    #: This constant has a value of "GI"
    TYPE_GI = "GI"

    #: A constant which can be used with the type property of a FsuCollectionSummary.
    #: This constant has a value of "GUEST_OS"
    TYPE_GUEST_OS = "GUEST_OS"

    #: A constant which can be used with the type property of a FsuCollectionSummary.
    #: This constant has a value of "EXADB_STACK"
    TYPE_EXADB_STACK = "EXADB_STACK"

    #: A constant which can be used with the service_type property of a FsuCollectionSummary.
    #: This constant has a value of "EXACS"
    SERVICE_TYPE_EXACS = "EXACS"

    #: A constant which can be used with the service_type property of a FsuCollectionSummary.
    #: This constant has a value of "EXACC"
    SERVICE_TYPE_EXACC = "EXACC"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a FsuCollectionSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new FsuCollectionSummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.GiFsuCollectionSummary`
        * :class:`~oci.fleet_software_update.models.ExadbStackFsuCollectionSummary`
        * :class:`~oci.fleet_software_update.models.DbFsuCollectionSummary`
        * :class:`~oci.fleet_software_update.models.GuestOsFsuCollectionSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FsuCollectionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this FsuCollectionSummary.
        :type display_name: str

        :param type:
            The value to assign to the type property of this FsuCollectionSummary.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this FsuCollectionSummary.
            Allowed values for this property are: "EXACS", "EXACC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this FsuCollectionSummary.
        :type compartment_id: str

        :param active_fsu_cycle:
            The value to assign to the active_fsu_cycle property of this FsuCollectionSummary.
        :type active_fsu_cycle: oci.fleet_software_update.models.ActiveCycleDetails

        :param target_count:
            The value to assign to the target_count property of this FsuCollectionSummary.
        :type target_count: int

        :param time_created:
            The value to assign to the time_created property of this FsuCollectionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FsuCollectionSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FsuCollectionSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FsuCollectionSummary.
        :type lifecycle_details: str

        :param last_completed_fsu_cycle_id:
            The value to assign to the last_completed_fsu_cycle_id property of this FsuCollectionSummary.
        :type last_completed_fsu_cycle_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FsuCollectionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FsuCollectionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this FsuCollectionSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'type': 'str',
            'service_type': 'str',
            'compartment_id': 'str',
            'active_fsu_cycle': 'ActiveCycleDetails',
            'target_count': 'int',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'last_completed_fsu_cycle_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'type': 'type',
            'service_type': 'serviceType',
            'compartment_id': 'compartmentId',
            'active_fsu_cycle': 'activeFsuCycle',
            'target_count': 'targetCount',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'last_completed_fsu_cycle_id': 'lastCompletedFsuCycleId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._type = None
        self._service_type = None
        self._compartment_id = None
        self._active_fsu_cycle = None
        self._target_count = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._last_completed_fsu_cycle_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'GI':
            return 'GiFsuCollectionSummary'

        if type == 'EXADB_STACK':
            return 'ExadbStackFsuCollectionSummary'

        if type == 'DB':
            return 'DbFsuCollectionSummary'

        if type == 'GUEST_OS':
            return 'GuestOsFsuCollectionSummary'
        else:
            return 'FsuCollectionSummary'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FsuCollectionSummary.
        The `OCID`__ of the Exadata Fleet Update Collection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this FsuCollectionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FsuCollectionSummary.
        The `OCID`__ of the Exadata Fleet Update Collection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this FsuCollectionSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FsuCollectionSummary.
        The user-friendly name for the Exadata Fleet Update Collection.


        :return: The display_name of this FsuCollectionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FsuCollectionSummary.
        The user-friendly name for the Exadata Fleet Update Collection.


        :param display_name: The display_name of this FsuCollectionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this FsuCollectionSummary.
        Exadata Fleet Update Collection type.

        Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this FsuCollectionSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this FsuCollectionSummary.
        Exadata Fleet Update Collection type.


        :param type: The type of this FsuCollectionSummary.
        :type: str
        """
        allowed_values = ["DB", "GI", "GUEST_OS", "EXADB_STACK"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this FsuCollectionSummary.
        Exadata service type for the target resource members.

        Allowed values for this property are: "EXACS", "EXACC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_type of this FsuCollectionSummary.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this FsuCollectionSummary.
        Exadata service type for the target resource members.


        :param service_type: The service_type of this FsuCollectionSummary.
        :type: str
        """
        allowed_values = ["EXACS", "EXACC"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            service_type = 'UNKNOWN_ENUM_VALUE'
        self._service_type = service_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FsuCollectionSummary.
        The `OCID`__ of the Compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this FsuCollectionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FsuCollectionSummary.
        The `OCID`__ of the Compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this FsuCollectionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def active_fsu_cycle(self):
        """
        Gets the active_fsu_cycle of this FsuCollectionSummary.

        :return: The active_fsu_cycle of this FsuCollectionSummary.
        :rtype: oci.fleet_software_update.models.ActiveCycleDetails
        """
        return self._active_fsu_cycle

    @active_fsu_cycle.setter
    def active_fsu_cycle(self, active_fsu_cycle):
        """
        Sets the active_fsu_cycle of this FsuCollectionSummary.

        :param active_fsu_cycle: The active_fsu_cycle of this FsuCollectionSummary.
        :type: oci.fleet_software_update.models.ActiveCycleDetails
        """
        self._active_fsu_cycle = active_fsu_cycle

    @property
    def target_count(self):
        """
        Gets the target_count of this FsuCollectionSummary.
        Number of targets that are members of this Collection.


        :return: The target_count of this FsuCollectionSummary.
        :rtype: int
        """
        return self._target_count

    @target_count.setter
    def target_count(self, target_count):
        """
        Sets the target_count of this FsuCollectionSummary.
        Number of targets that are members of this Collection.


        :param target_count: The target_count of this FsuCollectionSummary.
        :type: int
        """
        self._target_count = target_count

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FsuCollectionSummary.
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.


        :return: The time_created of this FsuCollectionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FsuCollectionSummary.
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this FsuCollectionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this FsuCollectionSummary.
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this FsuCollectionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FsuCollectionSummary.
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this FsuCollectionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FsuCollectionSummary.
        The current state of the Exadata Fleet Update Collection.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FsuCollectionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FsuCollectionSummary.
        The current state of the Exadata Fleet Update Collection.


        :param lifecycle_state: The lifecycle_state of this FsuCollectionSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this FsuCollectionSummary.
        A message describing the current state in more detail.
        For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this FsuCollectionSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FsuCollectionSummary.
        A message describing the current state in more detail.
        For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this FsuCollectionSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def last_completed_fsu_cycle_id(self):
        """
        Gets the last_completed_fsu_cycle_id of this FsuCollectionSummary.
        The `OCID`__ of last completed FSU Cycle.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The last_completed_fsu_cycle_id of this FsuCollectionSummary.
        :rtype: str
        """
        return self._last_completed_fsu_cycle_id

    @last_completed_fsu_cycle_id.setter
    def last_completed_fsu_cycle_id(self, last_completed_fsu_cycle_id):
        """
        Sets the last_completed_fsu_cycle_id of this FsuCollectionSummary.
        The `OCID`__ of last completed FSU Cycle.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param last_completed_fsu_cycle_id: The last_completed_fsu_cycle_id of this FsuCollectionSummary.
        :type: str
        """
        self._last_completed_fsu_cycle_id = last_completed_fsu_cycle_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this FsuCollectionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this FsuCollectionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FsuCollectionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this FsuCollectionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this FsuCollectionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this FsuCollectionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FsuCollectionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this FsuCollectionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FsuCollectionSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FsuCollectionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FsuCollectionSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FsuCollectionSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
