# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .goal_software_component_details import GoalSoftwareComponentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GiGoalSoftwareComponentDetails(GoalSoftwareComponentDetails):
    """
    Details of goal version for 'GI' component in an 'EXADB_STACK' type Exadata Fleet Update Collection.
    """

    #: A constant which can be used with the home_policy property of a GiGoalSoftwareComponentDetails.
    #: This constant has a value of "CREATE_NEW"
    HOME_POLICY_CREATE_NEW = "CREATE_NEW"

    #: A constant which can be used with the home_policy property of a GiGoalSoftwareComponentDetails.
    #: This constant has a value of "USE_EXISTING"
    HOME_POLICY_USE_EXISTING = "USE_EXISTING"

    def __init__(self, **kwargs):
        """
        Initializes a new GiGoalSoftwareComponentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GiGoalSoftwareComponentDetails.component_type` attribute
        of this class is ``GI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_type:
            The value to assign to the component_type property of this GiGoalSoftwareComponentDetails.
            Allowed values for this property are: "GI", "GUEST_OS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type component_type: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this GiGoalSoftwareComponentDetails.
        :type goal_version_details: oci.fleet_software_update.models.GiGoalVersionDetails

        :param home_policy:
            The value to assign to the home_policy property of this GiGoalSoftwareComponentDetails.
            Allowed values for this property are: "CREATE_NEW", "USE_EXISTING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type home_policy: str

        :param new_home_prefix:
            The value to assign to the new_home_prefix property of this GiGoalSoftwareComponentDetails.
        :type new_home_prefix: str

        """
        self.swagger_types = {
            'component_type': 'str',
            'goal_version_details': 'GiGoalVersionDetails',
            'home_policy': 'str',
            'new_home_prefix': 'str'
        }
        self.attribute_map = {
            'component_type': 'componentType',
            'goal_version_details': 'goalVersionDetails',
            'home_policy': 'homePolicy',
            'new_home_prefix': 'newHomePrefix'
        }
        self._component_type = None
        self._goal_version_details = None
        self._home_policy = None
        self._new_home_prefix = None
        self._component_type = 'GI'

    @property
    def goal_version_details(self):
        """
        **[Required]** Gets the goal_version_details of this GiGoalSoftwareComponentDetails.

        :return: The goal_version_details of this GiGoalSoftwareComponentDetails.
        :rtype: oci.fleet_software_update.models.GiGoalVersionDetails
        """
        return self._goal_version_details

    @goal_version_details.setter
    def goal_version_details(self, goal_version_details):
        """
        Sets the goal_version_details of this GiGoalSoftwareComponentDetails.

        :param goal_version_details: The goal_version_details of this GiGoalSoftwareComponentDetails.
        :type: oci.fleet_software_update.models.GiGoalVersionDetails
        """
        self._goal_version_details = goal_version_details

    @property
    def home_policy(self):
        """
        Gets the home_policy of this GiGoalSoftwareComponentDetails.
        Goal home policy to use when Staging the Goal Version during patching.
        CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version.
        USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.
          If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.
          If more than one existing home for the selected image is found, then the home with the least number of databases will be used.
          If multiple homes have the least number of databases, then a home will be selected at random.

        Allowed values for this property are: "CREATE_NEW", "USE_EXISTING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The home_policy of this GiGoalSoftwareComponentDetails.
        :rtype: str
        """
        return self._home_policy

    @home_policy.setter
    def home_policy(self, home_policy):
        """
        Sets the home_policy of this GiGoalSoftwareComponentDetails.
        Goal home policy to use when Staging the Goal Version during patching.
        CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version.
        USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.
          If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.
          If more than one existing home for the selected image is found, then the home with the least number of databases will be used.
          If multiple homes have the least number of databases, then a home will be selected at random.


        :param home_policy: The home_policy of this GiGoalSoftwareComponentDetails.
        :type: str
        """
        allowed_values = ["CREATE_NEW", "USE_EXISTING"]
        if not value_allowed_none_or_none_sentinel(home_policy, allowed_values):
            home_policy = 'UNKNOWN_ENUM_VALUE'
        self._home_policy = home_policy

    @property
    def new_home_prefix(self):
        """
        Gets the new_home_prefix of this GiGoalSoftwareComponentDetails.
        Prefix name used for new DB home resources created as part of the Stage Action.
        Format: <specified_prefix>_<timestamp>
        If not specified, a default OCI DB home resource will be generated for the new DB home resources created.


        :return: The new_home_prefix of this GiGoalSoftwareComponentDetails.
        :rtype: str
        """
        return self._new_home_prefix

    @new_home_prefix.setter
    def new_home_prefix(self, new_home_prefix):
        """
        Sets the new_home_prefix of this GiGoalSoftwareComponentDetails.
        Prefix name used for new DB home resources created as part of the Stage Action.
        Format: <specified_prefix>_<timestamp>
        If not specified, a default OCI DB home resource will be generated for the new DB home resources created.


        :param new_home_prefix: The new_home_prefix of this GiGoalSoftwareComponentDetails.
        :type: str
        """
        self._new_home_prefix = new_home_prefix

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
