# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .discovery_details import DiscoveryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsDiscoveryDetails(DiscoveryDetails):
    """
    Details to create a 'GUEST_OS' type Exadata Fleet Update Discovery.
    """

    #: A constant which can be used with the source_major_version property of a GuestOsDiscoveryDetails.
    #: This constant has a value of "EXA_OL_5"
    SOURCE_MAJOR_VERSION_EXA_OL_5 = "EXA_OL_5"

    #: A constant which can be used with the source_major_version property of a GuestOsDiscoveryDetails.
    #: This constant has a value of "EXA_OL_6"
    SOURCE_MAJOR_VERSION_EXA_OL_6 = "EXA_OL_6"

    #: A constant which can be used with the source_major_version property of a GuestOsDiscoveryDetails.
    #: This constant has a value of "EXA_OL_7"
    SOURCE_MAJOR_VERSION_EXA_OL_7 = "EXA_OL_7"

    #: A constant which can be used with the source_major_version property of a GuestOsDiscoveryDetails.
    #: This constant has a value of "EXA_OL_8"
    SOURCE_MAJOR_VERSION_EXA_OL_8 = "EXA_OL_8"

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsDiscoveryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsDiscoveryDetails.type` attribute
        of this class is ``GUEST_OS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuestOsDiscoveryDetails.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this GuestOsDiscoveryDetails.
            Allowed values for this property are: "EXACS", "EXACC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_type: str

        :param source_major_version:
            The value to assign to the source_major_version property of this GuestOsDiscoveryDetails.
            Allowed values for this property are: "EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source_major_version: str

        :param criteria:
            The value to assign to the criteria property of this GuestOsDiscoveryDetails.
        :type criteria: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails

        """
        self.swagger_types = {
            'type': 'str',
            'service_type': 'str',
            'source_major_version': 'str',
            'criteria': 'GuestOsFleetDiscoveryDetails'
        }
        self.attribute_map = {
            'type': 'type',
            'service_type': 'serviceType',
            'source_major_version': 'sourceMajorVersion',
            'criteria': 'criteria'
        }
        self._type = None
        self._service_type = None
        self._source_major_version = None
        self._criteria = None
        self._type = 'GUEST_OS'

    @property
    def source_major_version(self):
        """
        **[Required]** Gets the source_major_version of this GuestOsDiscoveryDetails.
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the results for an Exadata Fleet Update Discovery.
        Major Versions of Exadata Software are demarcated by the underlying Oracle Linux OS version.
        For more details, refer to `Oracle document 2075007.1`__

        __ https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html

        Allowed values for this property are: "EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source_major_version of this GuestOsDiscoveryDetails.
        :rtype: str
        """
        return self._source_major_version

    @source_major_version.setter
    def source_major_version(self, source_major_version):
        """
        Sets the source_major_version of this GuestOsDiscoveryDetails.
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in the results for an Exadata Fleet Update Discovery.
        Major Versions of Exadata Software are demarcated by the underlying Oracle Linux OS version.
        For more details, refer to `Oracle document 2075007.1`__

        __ https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html


        :param source_major_version: The source_major_version of this GuestOsDiscoveryDetails.
        :type: str
        """
        allowed_values = ["EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8"]
        if not value_allowed_none_or_none_sentinel(source_major_version, allowed_values):
            source_major_version = 'UNKNOWN_ENUM_VALUE'
        self._source_major_version = source_major_version

    @property
    def criteria(self):
        """
        **[Required]** Gets the criteria of this GuestOsDiscoveryDetails.

        :return: The criteria of this GuestOsDiscoveryDetails.
        :rtype: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria):
        """
        Sets the criteria of this GuestOsDiscoveryDetails.

        :param criteria: The criteria of this GuestOsDiscoveryDetails.
        :type: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails
        """
        self._criteria = criteria

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
