# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .index_config import IndexConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciDatabaseConfig(IndexConfig):
    """
    The details of the customer Database Connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciDatabaseConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.OciDatabaseConfig.index_config_type` attribute
        of this class is ``OCI_DATABASE_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param index_config_type:
            The value to assign to the index_config_type property of this OciDatabaseConfig.
            Allowed values for this property are: "DEFAULT_INDEX_CONFIG", "OCI_OPEN_SEARCH_INDEX_CONFIG", "OCI_DATABASE_CONFIG"
        :type index_config_type: str

        :param database_connection:
            The value to assign to the database_connection property of this OciDatabaseConfig.
        :type database_connection: oci.generative_ai_agent.models.DatabaseConnection

        :param database_functions:
            The value to assign to the database_functions property of this OciDatabaseConfig.
        :type database_functions: list[oci.generative_ai_agent.models.DatabaseFunction]

        """
        self.swagger_types = {
            'index_config_type': 'str',
            'database_connection': 'DatabaseConnection',
            'database_functions': 'list[DatabaseFunction]'
        }
        self.attribute_map = {
            'index_config_type': 'indexConfigType',
            'database_connection': 'databaseConnection',
            'database_functions': 'databaseFunctions'
        }
        self._index_config_type = None
        self._database_connection = None
        self._database_functions = None
        self._index_config_type = 'OCI_DATABASE_CONFIG'

    @property
    def database_connection(self):
        """
        **[Required]** Gets the database_connection of this OciDatabaseConfig.

        :return: The database_connection of this OciDatabaseConfig.
        :rtype: oci.generative_ai_agent.models.DatabaseConnection
        """
        return self._database_connection

    @database_connection.setter
    def database_connection(self, database_connection):
        """
        Sets the database_connection of this OciDatabaseConfig.

        :param database_connection: The database_connection of this OciDatabaseConfig.
        :type: oci.generative_ai_agent.models.DatabaseConnection
        """
        self._database_connection = database_connection

    @property
    def database_functions(self):
        """
        **[Required]** Gets the database_functions of this OciDatabaseConfig.
        Array of Database functions to be used.


        :return: The database_functions of this OciDatabaseConfig.
        :rtype: list[oci.generative_ai_agent.models.DatabaseFunction]
        """
        return self._database_functions

    @database_functions.setter
    def database_functions(self, database_functions):
        """
        Sets the database_functions of this OciDatabaseConfig.
        Array of Database functions to be used.


        :param database_functions: The database_functions of this OciDatabaseConfig.
        :type: list[oci.generative_ai_agent.models.DatabaseFunction]
        """
        self._database_functions = database_functions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
