# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_config import ToolConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RagToolConfig(ToolConfig):
    """
    The configuration for RAG Tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RagToolConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.RagToolConfig.tool_config_type` attribute
        of this class is ``RAG_TOOL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this RagToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG"
        :type tool_config_type: str

        :param knowledge_base_configs:
            The value to assign to the knowledge_base_configs property of this RagToolConfig.
        :type knowledge_base_configs: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]

        :param generation_llm_customization:
            The value to assign to the generation_llm_customization property of this RagToolConfig.
        :type generation_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        """
        self.swagger_types = {
            'tool_config_type': 'str',
            'knowledge_base_configs': 'list[KnowledgeBaseConfig]',
            'generation_llm_customization': 'LlmCustomization'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType',
            'knowledge_base_configs': 'knowledgeBaseConfigs',
            'generation_llm_customization': 'generationLlmCustomization'
        }
        self._tool_config_type = None
        self._knowledge_base_configs = None
        self._generation_llm_customization = None
        self._tool_config_type = 'RAG_TOOL_CONFIG'

    @property
    def knowledge_base_configs(self):
        """
        **[Required]** Gets the knowledge_base_configs of this RagToolConfig.
        The KnowledgeBase configurations that this RAG Tool uses


        :return: The knowledge_base_configs of this RagToolConfig.
        :rtype: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]
        """
        return self._knowledge_base_configs

    @knowledge_base_configs.setter
    def knowledge_base_configs(self, knowledge_base_configs):
        """
        Sets the knowledge_base_configs of this RagToolConfig.
        The KnowledgeBase configurations that this RAG Tool uses


        :param knowledge_base_configs: The knowledge_base_configs of this RagToolConfig.
        :type: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]
        """
        self._knowledge_base_configs = knowledge_base_configs

    @property
    def generation_llm_customization(self):
        """
        Gets the generation_llm_customization of this RagToolConfig.

        :return: The generation_llm_customization of this RagToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._generation_llm_customization

    @generation_llm_customization.setter
    def generation_llm_customization(self, generation_llm_customization):
        """
        Sets the generation_llm_customization of this RagToolConfig.

        :param generation_llm_customization: The generation_llm_customization of this RagToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._generation_llm_customization = generation_llm_customization

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
