# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PersonallyIdentifiableInformationResult(object):
    """
    An item of personally identifiable information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PersonallyIdentifiableInformationResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param length:
            The value to assign to the length property of this PersonallyIdentifiableInformationResult.
        :type length: int

        :param offset:
            The value to assign to the offset property of this PersonallyIdentifiableInformationResult.
        :type offset: int

        :param text:
            The value to assign to the text property of this PersonallyIdentifiableInformationResult.
        :type text: str

        :param label:
            The value to assign to the label property of this PersonallyIdentifiableInformationResult.
        :type label: str

        :param score:
            The value to assign to the score property of this PersonallyIdentifiableInformationResult.
        :type score: float

        """
        self.swagger_types = {
            'length': 'int',
            'offset': 'int',
            'text': 'str',
            'label': 'str',
            'score': 'float'
        }
        self.attribute_map = {
            'length': 'length',
            'offset': 'offset',
            'text': 'text',
            'label': 'label',
            'score': 'score'
        }
        self._length = None
        self._offset = None
        self._text = None
        self._label = None
        self._score = None

    @property
    def length(self):
        """
        **[Required]** Gets the length of this PersonallyIdentifiableInformationResult.
        The length of the personally identifiable information.


        :return: The length of this PersonallyIdentifiableInformationResult.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this PersonallyIdentifiableInformationResult.
        The length of the personally identifiable information.


        :param length: The length of this PersonallyIdentifiableInformationResult.
        :type: int
        """
        self._length = length

    @property
    def offset(self):
        """
        **[Required]** Gets the offset of this PersonallyIdentifiableInformationResult.
        The offset of the personally identifiable information.


        :return: The offset of this PersonallyIdentifiableInformationResult.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this PersonallyIdentifiableInformationResult.
        The offset of the personally identifiable information.


        :param offset: The offset of this PersonallyIdentifiableInformationResult.
        :type: int
        """
        self._offset = offset

    @property
    def text(self):
        """
        **[Required]** Gets the text of this PersonallyIdentifiableInformationResult.
        The text of the personally identifiable information.


        :return: The text of this PersonallyIdentifiableInformationResult.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this PersonallyIdentifiableInformationResult.
        The text of the personally identifiable information.


        :param text: The text of this PersonallyIdentifiableInformationResult.
        :type: str
        """
        self._text = text

    @property
    def label(self):
        """
        **[Required]** Gets the label of this PersonallyIdentifiableInformationResult.
        The label of the personally identifiable information.


        :return: The label of this PersonallyIdentifiableInformationResult.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this PersonallyIdentifiableInformationResult.
        The label of the personally identifiable information.


        :param label: The label of this PersonallyIdentifiableInformationResult.
        :type: str
        """
        self._label = label

    @property
    def score(self):
        """
        **[Required]** Gets the score of this PersonallyIdentifiableInformationResult.
        The score of the personally identifiable information.


        :return: The score of this PersonallyIdentifiableInformationResult.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this PersonallyIdentifiableInformationResult.
        The score of the personally identifiable information.


        :param score: The score of this PersonallyIdentifiableInformationResult.
        :type: float
        """
        self._score = score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
