# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestPerformanceTuningAnalysisDetails(object):
    """
    The data to create Performance Tuning Analysis.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RequestPerformanceTuningAnalysisDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this RequestPerformanceTuningAnalysisDetails.
        :type compartment_id: str

        :param targets:
            The value to assign to the targets property of this RequestPerformanceTuningAnalysisDetails.
        :type targets: list[oci.jms_utils.models.PerformanceTuningAnalysisTarget]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RequestPerformanceTuningAnalysisDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RequestPerformanceTuningAnalysisDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'targets': 'list[PerformanceTuningAnalysisTarget]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'targets': 'targets',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._targets = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RequestPerformanceTuningAnalysisDetails.
        The `OCID`__ of the compartment where the Performance Tuning Analysis will be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this RequestPerformanceTuningAnalysisDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RequestPerformanceTuningAnalysisDetails.
        The `OCID`__ of the compartment where the Performance Tuning Analysis will be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this RequestPerformanceTuningAnalysisDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def targets(self):
        """
        **[Required]** Gets the targets of this RequestPerformanceTuningAnalysisDetails.
        The list of targets for the Performance Tuning Analysis.


        :return: The targets of this RequestPerformanceTuningAnalysisDetails.
        :rtype: list[oci.jms_utils.models.PerformanceTuningAnalysisTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this RequestPerformanceTuningAnalysisDetails.
        The list of targets for the Performance Tuning Analysis.


        :param targets: The targets of this RequestPerformanceTuningAnalysisDetails.
        :type: list[oci.jms_utils.models.PerformanceTuningAnalysisTarget]
        """
        self._targets = targets

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this RequestPerformanceTuningAnalysisDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this RequestPerformanceTuningAnalysisDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RequestPerformanceTuningAnalysisDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this RequestPerformanceTuningAnalysisDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this RequestPerformanceTuningAnalysisDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this RequestPerformanceTuningAnalysisDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RequestPerformanceTuningAnalysisDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this RequestPerformanceTuningAnalysisDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
