# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogAnalyticsFieldUsages(object):
    """
    Contains information about resources such as parsers and sources that use the field.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogAnalyticsFieldUsages object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dependent_parsers:
            The value to assign to the dependent_parsers property of this LogAnalyticsFieldUsages.
        :type dependent_parsers: list[oci.log_analytics.models.DependentParser]

        :param dependent_sources:
            The value to assign to the dependent_sources property of this LogAnalyticsFieldUsages.
        :type dependent_sources: list[oci.log_analytics.models.DependentSource]

        """
        self.swagger_types = {
            'dependent_parsers': 'list[DependentParser]',
            'dependent_sources': 'list[DependentSource]'
        }
        self.attribute_map = {
            'dependent_parsers': 'dependentParsers',
            'dependent_sources': 'dependentSources'
        }
        self._dependent_parsers = None
        self._dependent_sources = None

    @property
    def dependent_parsers(self):
        """
        **[Required]** Gets the dependent_parsers of this LogAnalyticsFieldUsages.
        Parsers that depend on or use the field.


        :return: The dependent_parsers of this LogAnalyticsFieldUsages.
        :rtype: list[oci.log_analytics.models.DependentParser]
        """
        return self._dependent_parsers

    @dependent_parsers.setter
    def dependent_parsers(self, dependent_parsers):
        """
        Sets the dependent_parsers of this LogAnalyticsFieldUsages.
        Parsers that depend on or use the field.


        :param dependent_parsers: The dependent_parsers of this LogAnalyticsFieldUsages.
        :type: list[oci.log_analytics.models.DependentParser]
        """
        self._dependent_parsers = dependent_parsers

    @property
    def dependent_sources(self):
        """
        **[Required]** Gets the dependent_sources of this LogAnalyticsFieldUsages.
        Sources that depend on or use the field.


        :return: The dependent_sources of this LogAnalyticsFieldUsages.
        :rtype: list[oci.log_analytics.models.DependentSource]
        """
        return self._dependent_sources

    @dependent_sources.setter
    def dependent_sources(self, dependent_sources):
        """
        Sets the dependent_sources of this LogAnalyticsFieldUsages.
        Sources that depend on or use the field.


        :param dependent_sources: The dependent_sources of this LogAnalyticsFieldUsages.
        :type: list[oci.log_analytics.models.DependentSource]
        """
        self._dependent_sources = dependent_sources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
